%Nodes_1_tWH_IL_tHS.m     %(originally Nov1 motif)            %2006_03_06 %Ali

% 1099 G    <cWW (1) >  C 1257      %node5
% 1098 A    <tHS (10)>  G 1258      %node4
% 1097 A
% 1096 U    <tWH (-4)>  A 1259      %node3
%                       G 1260
% 1095 U    <cWW (1) >  A 1261      %node2

%Remark: The sequences are extracted from 5' -> 3' direction (1095-1099,1257-1261),
%so nodes start from the bottom up according to the above representation.

n=1;
  Node(n).type      = 'Initial';
  Node(n).nextnode  = n+1;
  Node(n).lpar      = 0.05;
  Node(n).rpar      = 0.05;
  
n=2;% 1095 U    <cWW (1) >  A 1261      %node2
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(1,4,1,0.013);
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [0.012*ones(16,1); 0];
  Node(n).rpar      = [1*ones(16,1); 0]; %(10/10), but sometimes 1, sometimes nothing, sometimes 3!!
  
n=3;% 1096 U    <tWH (-4)>  A 1259      %node3
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(-4,4,1,0.012);
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [1*ones(16,1); 0]; %required stacked base (the insertion)
  Node(n).rpar      = [(2/10)*ones(16,1); 0];
  
n=4;% 1098 A    <tHS (10)>  G 1258      %node4
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(10,1,3,0.011);
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [0.01*ones(16,1); 0];
  Node(n).rpar      = [0.011*ones(16,1); 0];

n=5;% 1099 G    <cWW (1) >  C 1257      %node5
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(1,3,2,0.01);
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [0.014*ones(16,1); 0];
  Node(n).rpar      = [0.012*ones(16,1); 0];

n=6;
  Node(n).type      = 'Hairpin';
  Node(n).subtype   = '....';
  Node(n).nextnode  = Inf;
  Node(n).P         = ones(17,1);
  Node(n).PIns      = 1;
  