%Nodes_23S_1850_1881.m or another name for the same
%Nodes_marismortui_1850_1881.m

n=1;                                            % current node
  Node(n).type      = 'Initial';                % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Node(n).lpar      = 0.05;                     % left insertion parameter
  Node(n).rpar      = 0.05;                     % right insertion parameter

n=2;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(1,4,1,0.02);    % slightly higher del prob
  Node(n).P         = ones(17,1)*Score;         % state to state transitions
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [0.01*ones(16,1); 0];     % right insertion parameters

n=3;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(1,3,2,0.012);
  Node(n).P         = ones(17,1)*Score;         % state to state transitions
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [0.01*ones(16,1); 0];     % right insertion parameters

n=4;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(1,1,4,0.011);
  Node(n).P         = ones(17,1)*Score;         % state to state transitions
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [0.01*ones(16,1); 0];     % right insertion parameters

n=5;                                            % current node
  Node(n).type      = 'Motif';                  % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Node(n).P         = [0.05*ones(17,1) 0.95*ones(17,1)];
                                                % state to state transitions
  Node(n).PIns	    = [0.05 0.95];              % when no previous state
  %%%%%%%%%%%
  Node(n).Left(1,:) = [1 2 4 5 6 7];            %3 is ignored because it may be bulged
  Node(n).Left(2,:) = [1 2 3 4 5 6];            % nucleotides to use on left
  Node(n).LIP       = [0.9 0.1];                % probs for insertion possibs
  Node(n).Right(1,:)= [8 7 6 4 2 1];            %numbers in the opposite way, meaning the same
  Node(n).Right(2,:)= [7 6 4 3 2 1];            % nucleotides to use on right
  Node(n).Right(3,:)= [7 6 5 4 2 1];            % nucleotides to use on right
  Node(n).Right(4,:)= [6 5 4 3 2 1];            % nucleotides to use on right
  Node(n).RIP       = [0.9 0.045 0.045 0.01];   % probs for insertion possibs
%  Node(n).RIP        = 1;
  Node(n).IBases(1,:)  = [1 12];
  Node(n).Score(:,:,1) = pIsoScore(1,1,3);
  Node(n).IBases(2,:)  = [2 11];
  Node(n).Score(:,:,2) = pIsoScore(1,2,3);
  Node(n).IBases(3,:)  = [3 9];
  Node(n).Score(:,:,3) = pIsoScore(2,2,3);
  Node(n).IBases(4,:)  = [5 8];
  Node(n).Score(:,:,4) = pIsoScore(8,1,4);
  Node(n).IBases(5,:)  = [6 7];
  Node(n).Score(:,:,5) = pIsoScore(5,1,2);
  Node(n).IBases(6,:)  = [1 6];
  Node(n).Score(:,:,6) = pIsoScore(11,2,1);
  Node(n).IBases(7,:)  = [6 12];
  Node(n).Score(:,:,7) = pIsoScore(12,1,3);
  Node(n).IBases(8,:)  = [2 5];
  Node(n).Score(:,:,8) = pIsoScore(-11,2,1);
  Node(n).IBases(9,:)  = [3 10];
  Node(n).Score(:,:,9) = pIsoScore(8,2,1);
  
n=6;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(1,4,1,0.01);
  Node(n).P         = ones(1,1)*Score;          % state to state transitions
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [0.01*ones(16,1); 0];     % right insertion parameters

n=7;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(1,2,3,0.01);
  Node(n).P         = ones(17,1)*Score;         % state to state transitions
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [0.01*ones(16,1); 0];     % right insertion parameters

n=8;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(1,2,3,0.01);
  Node(n).P         = ones(17,1)*Score;         %1,1 because there a HP after it
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [0.01*ones(16,1); 0];     % right insertion parameters

n=9;                                            % current node
  Node(n).type      = 'Hairpin';                % node type
  Node(n).subtype   = 'GNRA';                   %put '...' if you have internal loop separation only
  Node(n).nextnode  = Inf;                      % index of next node in tree
  Node(n).P         = ones(17,1);               % state to state transitions
  Node(n).PIns      = 1;                        % when no previous state

