%Nodes_Nov1_55.m
%%%%CASE 56 was chosen as best definition for this motif:
% 1099 G    <cWW (1) >  C 1257
% 1098 A    <tHS (10)>  G 1258
% 1097 A
% 1096 U    <tWH (-4)>  A 1259
%                       G 1260
% 1095 U    <cWW (1) >  A 1261

%Create alignments in this order: 1099-1095,1261-1257 (this will reverse the order with respect to source alignment, no big deal)
n=1;
  Node(n).type      = 'Initial';
  Node(n).nextnode  = n+1;
  Node(n).lpar      = 0.05;
  Node(n).rpar      = 0.05;

n=2;
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(1,3,2,0.01);
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [0.01*ones(16,1); 0];
  Node(n).rpar      = [0.01*ones(16,1); 0];
  
n=3;
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(10,1,3,0.011);
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [1*ones(16,1); 0];
  Node(n).rpar      = [(3/11)*ones(16,1); 0];

n=4;
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(-4,4,1,0.012); %notice that Hm 23S (IL96) has this bp as tSH (+10)
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [0.011*ones(16,1); 0];
  Node(n).rpar      = [(10/11)*ones(16,1); 0];
  
n=5;
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(1,3,1,0.013);
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [0.012*ones(16,1); 0];
  Node(n).rpar      = [0.011*ones(16,1); 0];
  
n=6;
  Node(n).type      = 'Hairpin';
  Node(n).subtype   = '....';
  Node(n).nextnode  = Inf;
  Node(n).P         = ones(17,1);
  Node(n).PIns      = 1;
  