%Nodes_Nov1_56.m
%%%%CASE 56 was chosen as best definition for this motif:
% 819 A     <cWW (1) >  U 794
% 818 A     <tHS (10)>  G 795
% 817 G     <tSH (10)>  A 796
% 816 G     <tSH (10)>  A 797
% 815 U     <cWW (1) >  G 798  %might want to code this bottom closing pair as CG instead of UG, try both ways

%Create alignments in this order: 819-815,798-794 (this will reverse the order with respect to source alignment, no big deal)
n=1;
  Node(n).type      = 'Initial';
  Node(n).nextnode  = n+1;
  Node(n).lpar      = 0.05;
  Node(n).rpar      = 0.05;

n=2;
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(1,1,4,6/14);
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [(1/14)*ones(16,1); 0]; %there is one bulge to the left after this bp
  Node(n).rpar      = [0.01*ones(16,1); 0];
  
n=3;
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(10,1,3,0.01);
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [(3/14)*ones(16,1); 0];
  Node(n).rpar      = [0.011*ones(16,1); 0];

n=4;
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(10,3,1,2/14);
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [(3/12)*ones(16,1); 0];
  Node(n).rpar      = [(1/12)*ones(16,1); 0];
  
n=5;
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(10,3,1,0.02);
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [0.012*ones(16,1); 0];
  Node(n).rpar      = [(1/14)*ones(16,1); 0];
  
n=6;
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  %Score             = pIsoScore(1,4,3,6/14); %this is UG  %%%%Craig said it should be 1 (not -1). Then how to differentiate between UG and GU?
  Score             = pIsoScore(1,2,3,6/14); %this is CG
  Node(n).P         = ones(17,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [0.013*ones(16,1); 0];
  Node(n).rpar      = [0.013*ones(16,1); 0];
  
n=7;
  Node(n).type      = 'Hairpin';
  Node(n).subtype   = '....';
  Node(n).nextnode  = Inf;
  Node(n).P         = ones(17,1);
  Node(n).PIns      = 1;
  
  

%%%%CASE 55 definition, without closing pairs:
% 1259 A	<tHW (-4)>	U 1096
% 1097 A
% 1098 A    <tHS (10)>  G 1258

% n=1;
%   Node(n).type      = 'Initial';
%   Node(n).nextnode  = n+1;
%   Node(n).lpar      = 0.05;
%   Node(n).rpar      = 0.05;
% 
% n=2;
%   Node(n).type      = 'Basepair';
%   Node(n).nextnode  = n+1;
%   Score             = pIsoScore(-4,1,4,0.01);
%   Node(n).P         = ones(17,1)*Score;
%   Node(n).PIns	    = Score;
%   Node(n).lpar      = [1*ones(16,1); 0]; %there is one bulge to the left after this bp
%   Node(n).rpar      = [0.01*ones(16,1); 0];
%   
% n=3;
%   Node(n).type      = 'Basepair';
%   Node(n).nextnode  = n+1;
%   Score             = pIsoScore(10,1,3,0.02);
%   Node(n).P         = ones(17,1)*Score;
%   Node(n).PIns	    = Score;
%   Node(n).lpar      = [2*ones(16,1); 0];
%   Node(n).rpar      = [0.01*ones(16,1); 0];
% 
% n=4;
%   Node(n).type      = 'Hairpin';
%   Node(n).subtype   = '....';
%   Node(n).nextnode  = Inf;
%   Node(n).P         = ones(17,1);
%   Node(n).PIns      = 1;

