%Nodes_h11IL1.m

n=1;
  Node(n).type      = 'Initial';
  Node(n).nextnode  = n+1;
  Node(n).lpar      = 0.05;
  Node(n).rpar      = 0.05;

n=2;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(1,2,3,0.02);    % slightly higher del prob
  Node(n).P         = ones(17,1)*Score;         % state to state transitions
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [0.01*ones(16,1); 0];     % right insertion parameters
  
n=3;
  Node(n).type      = 'Motif';
  Node(n).nextnode  = n+1;
  Node(n).P         = [0.05*ones(17,1) 0.95*ones(17,1)];
  Node(n).PIns	    = [0.05 0.95];
  %%%%%%%%%%%
  Node(n).Left(1,:) = [1 3 4];
  Node(n).Left(2,:) = [1 2 3];
  Node(n).LIP       = [0.9 0.1];
  Node(n).Right(1,:)= [6 3 2 1];
  Node(n).Right(1,:)= [5 3 2 1];
  Node(n).Right(1,:)= [4 3 2 1];
  Node(n).RIP       = [.85 .1 .05];
  Node(n).IBases(1,:)  = [1 6];
  Node(n).Score(:,:,1) = pIsoScore(4,1,1);
  Node(n).IBases(2,:)  = [2 7];
  Node(n).Score(:,:,2) = pIsoScore(1,2,2);
  Node(n).IBases(3,:)  = [3 5];
  Node(n).Score(:,:,3) = pIsoScore(10,1,3);
  Node(n).IBases(4,:)  = [3 4];
  Node(n).Score(:,:,4) = pIsoScore(12,1,3);
  
n=4;
  Node(n).type      = 'Basepair';
  Node(n).nextnode  = n+1;
  Score             = pIsoScore(1,3,2,0.01);
  Node(n).P         = ones(1,1)*Score;
  Node(n).PIns	    = Score;
  Node(n).lpar      = [0.01*ones(16,1); 0];
  Node(n).rpar      = [0.01*ones(16,1); 0];

n=4;
  Node(n).type      = 'Hairpin';
  Node(n).subtype   = '....';
  Node(n).nextnode  = Inf;
  Node(n).P         = ones(17,1);
  Node(n).PIns      = 1;

