%mMakeFASTAfromParserOutput.m
%First, manually delete the first three header lines and keep only the lines containg sequences.
%Also, delete any extra characters at the bottom, like >>
%Limitation: Organism name should not be more than 10 words (pretty easy to abide by, isn't it?)
%So each line should start with a sequence number, then sequence, then sequence number again (!!), then score (log prob), and finally fasta name.

Path='C:\AliRes\Automatic Structural Alignment\5S Rfam FULL results\Euryarchaeota\';
TextFile = 'SCFG-MRF_alignment_of_archaeal_sequences.txt';
TextFileAndPath = strcat(Path,TextFile);
ExtLoc = strfind(TextFileAndPath,'.');
TextFileNoExt = TextFileAndPath(1:ExtLoc-1);
FastaFile = strcat(TextFileNoExt,'.fasta'); %Write file

%Read
[Num1,Seq,Num2,LP,FName1,FName2,FName3,FName4,FName5,FName6,FName7,FName8,FName9,FName10] = ...
    textread(TextFileAndPath,'%s%s%s%s%s%s%s%s%s%s%s%s%s%s');
for i=1:length(FName1)
    FName{i} = [FName1{i},' ',FName2{i},' ',FName3{i},' ',FName4{i},' ',FName5{i},' ',FName6{i},' ',FName7{i},' ',FName8{i},' ',FName9{i},' ',FName10{i}];
end
SeqNoSymbols=regexprep(Seq,'*','');           %remove * that mark the borders of motifs
SeqNoSymbols=regexprep(SeqNoSymbols,'+','');    %also remove +'s that mark motif swaps (alternative nodes)

%Write
fidOUT = fopen(FastaFile,'w+');
for i=1:length(FName)
    fprintf(fidOUT,'%s%s\n','>',strcat(FName{i},' (',LP{i},')'));
    fprintf(fidOUT,'%s\n',SeqNoSymbols{i});
end
fclose(fidOUT);
