function varargout = mMasterParserGUI(varargin)
% MMASTERPARSERGUI M-file for mMasterParserGUI.fig
%      MMASTERPARSERGUI, by itself, creates a new MMASTERPARSERGUI or raises the existing
%      singleton*.
%
%      H = MMASTERPARSERGUI returns the handle to a new MMASTERPARSERGUI or the handle to
%      the existing singleton*.
%
%      MMASTERPARSERGUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MMASTERPARSERGUI.M with the given input arguments.
%
%      MMASTERPARSERGUI('Property','Value',...) creates a new MMASTERPARSERGUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before mMasterParserGUI_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to mMasterParserGUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help mMasterParserGUI

% Last Modified by GUIDE v2.5 11-Nov-2005 13:13:32

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @mMasterParserGUI_OpeningFcn, ...
    'gui_OutputFcn',  @mMasterParserGUI_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before mMasterParserGUI is made visible.
function mMasterParserGUI_OpeningFcn(hObject, eventdata, handles, varargin)
% clc
% 'open'
load('Preferences.mat');%This reads the last settings from the previous session
% MasterParser_position
GUI_dimentions=get(hObject, 'position');%Used to extract the DIMENTIONS (the 3rd and 4th component) in case some changes to the GUI shape were made...
MasterParser_position=[MasterParser_position(1),MasterParser_position(2),GUI_dimentions(3),GUI_dimentions(4)];
save('Preferences.mat','Audio','ShowTotals','ShowNs','ShowGaps','ShowExpected','Rounding','main_position','preferences_position','OneByOne_position','OneByOne_PercentsCounts','MasterParser_position','FastaExtractor_position','FastaFixer_position','SeqViewerYES','GUspecialYES'); 
set(hObject, 'position', MasterParser_position);
% MasterParser_position

if ~isempty(varargin)
    FastaPath       =   varargin{1};      	%this is how you import from the main GUI (mMutualCounterGUI)
    FastaFilename   =   varargin{2};      	%this is how you import from the main GUI (mMutualCounterGUI)
    set(handles.FastaFileEdit,'String',strcat(FastaPath,FastaFilename))
else FastaPath = pwd;
end

x=ls('Alignment_Parser/Nodes_*.m');
set(handles.NodesFilePopupmenu,'String',x);
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to mMasterParserGUI (see VARARGIN)

% Choose default command line output for mMasterParserGUI
handles.output = hObject;

handles.FastaPath = FastaPath;
guidata(hObject, handles);

% UIWAIT makes mMasterParserGUI wait for user response (see UIRESUME)
% uiwait(handles.FigMasterParser);


% --- Outputs from this function are returned to the command line.
function varargout = mMasterParserGUI_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


function FastaFileEdit_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function FastaFileEdit_Callback(hObject, eventdata, handles)


function FastaFileBrowse_Callback(hObject, eventdata, handles)
if ispc
[name,path] = uigetfile({'*.fasta','*.fasta';'*.*','*.*'},'Pick FASTA file to be aligned',handles.FastaPath);
else
[name,path] = uigetfile({'*.fasta','*.fasta'},'Pick FASTA file to be aligned',handles.FastaPath);
end

FastaFilename=strcat(path,name);
set(handles.FastaFileEdit,'String',FastaFilename);


function NodesFilePopupmenu_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function NodesFilePopupmenu_Callback(hObject, eventdata, handles)
curdir=pwd;
if strcmp(curdir(end-15:end),'Alignment_Parser')
    x=ls('Nodes_*.m');
    set(handles.NodesFilePopupmenu,'String',{x});
else
    x=ls('Alignment_Parser\Nodes_*.m');
    set(handles.NodesFilePopupmenu,'String',{x});
end


function NumToDoPopup_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function NumToDoPopup_Callback(hObject, eventdata, handles)


function LoadPreviousParsesYes_Callback(hObject, eventdata, handles)
function LoadPreviousParsesNo_Callback(hObject, eventdata, handles)


function RUN_Callback(hObject, eventdata, handles)
if exist('Preferences.mat','file')
    load('Preferences.mat'); %the only variale needed from hear is Audio
elseif exist('..\Preferences.mat','file')
    load('..\Preferences.mat'); %the only variale needed from hear is Audio
end

FastaFilename   = get(handles.FastaFileEdit,'String');

PREnumtodo      = get(handles.NumToDoPopup,'String');
x               = get(handles.NumToDoPopup,'Value');
numtodo         = str2num(PREnumtodo{x});
if isempty(numtodo) %In the one case where the value "All" is chosen
    numtodo = Inf;
end

PREmotifs       = get(handles.NodesFilePopupmenu,'String');
y               = get(handles.NodesFilePopupmenu,'Value');
ChosenPREmotif  = PREmotifs{y};
ind1            = findstr('Nodes_',ChosenPREmotif);
ind2            = findstr('.m',ChosenPREmotif);
motifs          = {ChosenPREmotif(ind1+6:ind2-1)};


if get(handles.LoadPreviousParsesYes,'Value')==1
    LoadPreviousParses = 1;
else
    LoadPreviousParses = 0;
end

RunAftermMasterParserGUI = 1;

fprintf('\n');
fprintf('%15s  %s\n','FastaFilename',FastaFilename);
fprintf('%15s  %g\n','numtodo',numtodo);
fprintf('%15s  %s\n','motifs',motifs{1});
message={'No','Yes'};
fprintf('%15s  %s\n','Load previous',message{LoadPreviousParses+1});
fprintf('\n\n');


mMasterParser



% --- Executes during object deletion, before destroying properties.
function FigMasterParser_DeleteFcn(hObject, eventdata, handles)
% 'close'
load('Preferences.mat');%This reads the last settings from the previous session
% MasterParser_position
MasterParser_position=get(hObject, 'position');  %Updated here just before closing, this way, the next time this GUI will open in the same location it was closed in
save('Preferences.mat','Audio','ShowTotals','ShowNs','ShowGaps','ShowExpected','Rounding','main_position','preferences_position','OneByOne_position','OneByOne_PercentsCounts','MasterParser_position','FastaExtractor_position','FastaFixer_position','SeqViewerYES','GUspecialYES');
% MasterParser_position
