%mPlot2SeqsBy2Models.m

path='C:\AliRes\_MatlabWork\MATLAB programs\Alignment_Analysis\Ribostral\Alignment_Parser\5p to 3p Automatic sequence alignment\Discrimination Comparisons 2x2\';

Alignment1=strcat(path,'1-tWH-IL-tHS_23S_Archaea_seqs.fasta');
Alignment2=strcat(path,'2-tSH-tWH-tHS_Archaea_sequences.fasta');
% Alignment1=strcat(path,'3-tSH-tSH-tHS_23S_Archaea_seqs_KTs removed.fasta');
% Alignment2=strcat(path,'4-tSH-IL-tHS_23S_Archaea_seqs.fasta');

Model1={'1_tWH_IL_tHS'};
Model2={'2_tSH_tWH_tHS'};
% Model1={'3_tSH_tSH_tHS_noKTs'};
% Model2={'4_tSH_IL_tHS'};

fprintf('\n%s\n','Parsing Alignment1 according to Model1:');
[len1 LogProb1(1,:)] = mMasterParserFunc(Alignment1,Model1,Inf,0);
fprintf('\n%s\n','Parsing Alignment2 according to Model1:');
[len2 LogProb2(1,:)] = mMasterParserFunc(Alignment2,Model1,Inf,0);
fprintf('\n%s\n','Parsing Alignment1 according to Model2:');
[len1 LogProb1(2,:)] = mMasterParserFunc(Alignment1,Model2,Inf,0);
fprintf('\n%s\n','Parsing Alignment2 according to Model2:');
[len2 LogProb2(2,:)] = mMasterParserFunc(Alignment2,Model2,Inf,0);

%figure
LogProbAllByModel1=[LogProb1(1,:) LogProb2(1,:)];
LogProbAllByModel2=[LogProb1(2,:) LogProb2(2,:)];
group=ones(1,len1+len2);
for i=len1+1:len1+len2
    group(i)=2;
end
gscatter(LogProbAllByModel1,LogProbAllByModel2,group,'rb','x.',5);

line([-17,-8],[-17 -8],'Color','k')

title('Discrimination Power')
rep1=strrep(Model1,'_','\_');NameModel1=[' ',rep1{1}];xlabel(strcat('LogProb according to',NameModel1,' motif (1x)'))
rep2=strrep(Model2,'_','\_');NameModel2=[' ',rep2{1}];ylabel(strcat('LogProb according to',NameModel2,' motif (2.)'))
