% pGetTraceInfo(Node,P,L) extracts trace info from P

function [t] = pGetTraceInfo(Node,P,L)

N = length(Node);

t(1).i     = 1;
t(1).j     = L;                              % length of sequence
t(1).state = 1;

for n = 1:length(Node),
  nextnode = Node(n).nextnode;
  i = t(n).i;
  j = t(n).j;
  s = t(n).state;

  switch Node(n).type,
    case {'Initial','Basepair'}
%[n s i j]
      t(n).a            = P(n,s).sub(i,j);
      t(n).b            = P(n,s).sub(j,i);
      t(n).mp           = P(n,s).mp(i,j);
      t(nextnode).i     = t(n).a;
      t(nextnode).j     = t(n).b;
      t(nextnode).state = P(n,s).next(i,j);
    case {'Motif'}
%[n s i j]
      t(n).a            = P(n,s).sub(i,j);
      t(n).b            = P(n,s).sub(j,i);
      t(n).l            = P(n,s).mp(j,i);
      t(n).r            = P(n,s).next(j,i);
      t(n).mp           = P(n,s).mp(i,j);
      t(nextnode).i     = t(n).a;
      t(nextnode).j     = t(n).b;
      t(nextnode).state = P(n,s).next(i,j);
    case 'Hairpin'
      t(n).mp           = P(n,s).mp(i,j);
    case 'Junction' 
      t(nextnode(1)).i     = t(n).i;
      t(nextnode(1)).j     = uint8(double(P(n,s).sub(i,j))-1);
      t(nextnode(1)).state = 1;
      t(nextnode(2)).i     = P(n,s).sub(i,j);
      t(nextnode(2)).j     = t(n).j;
      t(nextnode(2)).state = 1;
  end
end