% pMakeLoopHeader constructs a 3-line header for a multiple alignment

function [header] = pMakeLoopHeader(Node,maxinsert,n)

left1  = '';
left2  = '';
left3  = '';

right1 = '';
right2 = '';
right3 = '';

while (n <= length(Node)),                            % go through nodes

  switch Node(n).type,
    case 'Hairpin'
      left1  = [left1 '*H'];
      left2  = [left2 '*' num2str(mod(n,10))];
      left3  = [left3 '*' num2str(fix(n/10))];

      for a=1:maxinsert(n).hairpin-1,
        left1 = [left1 '-'];
        left2 = [left2 num2str(mod(n,10))];
        left3 = [left3 num2str(fix(n/10))];
      end

      right1 = ['*' right1];
      right2 = ['*' right2];
      right3 = ['*' right3];
      
    case 'Initial'
      for a=1:maxinsert(n).left,
        left1 = [left1 '-'];
        left2 = [left2 num2str(mod(n,10))];
        left3 = [left3 num2str(fix(n/10))];
      end
      for a=1:maxinsert(n).right,
        right1 = ['-' right1];
        right2 = [num2str(mod(n,10)) right2];
        right3 = [num2str(fix(n/10)) right3];
      end

    case 'Junction'
      t = pMakeLoopHeader(Node,maxinsert,Node(n).nextnode(1));
      left1  = [left1 t{1}];
      left2  = [left2 t{2}];
      left3  = [left3 t{3}];

      t = pMakeLoopHeader(Node,maxinsert,Node(n).nextnode(2));
      right1 = [ t{1} right1];
      right2 = [ t{2} right2];
      right3 = [ t{3} right3];

    case 'Basepair'
      left1  = [left1 '('];
      left2  = [left2 num2str(mod(n,10))];
      left3  = [left3 num2str(fix(n/10))];

      for a=1:maxinsert(n).left,
        left1 = [left1 '-'];
        left2 = [left2 num2str(mod(n,10))];
        left3 = [left3 num2str(fix(n/10))];
      end

      right1 = [')' right1];
      right2 = [num2str(mod(n,10)) right2];
      right3 = [num2str(fix(n/10)) right3];

      for a=1:maxinsert(n).right,
        right1 = ['-' right1];
        right2 = [num2str(mod(n,10)) right2];
        right3 = [num2str(fix(n/10)) right3];
      end

    case 'Motif'
      for a = 1:length(Node(n).Left(1,:))-1,
        left1 = [left1 'M'];
        for b=1:maxinsert(n).left(a),
          left1 = [left1 'B'];
        end
      end
      left1 = [left1 'M'];
      for a = 1:length(Node(n).Right(1,:))-1,
        right1 = ['M' right1];
        for b=1:maxinsert(n).right(a),
          right1 = ['B' right1];
        end
      end
      right1 = ['M' right1];

      for a=1:(length(Node(n).Left(1,:)) + sum(maxinsert(n).left)),
        left2  = [left2 num2str(mod(n,10))];
        left3  = [left3 num2str(fix(n/10))];
      end
      for a=1:(length(Node(n).Right(1,:)) + sum(maxinsert(n).right)),
        right2 = [num2str(mod(n,10)) right2];
        right3 = [num2str(fix(n/10)) right3];
      end
  end

  switch Node(n).type,
    case {'Initial', 'Basepair', 'Motif'}
      n = Node(n).nextnode(1);
    case {'Hairpin', 'Junction'}
      n = Inf;
  end

%fprintf('pMakeLoopHeader Node %d\n', n);
%fprintf('%s %s\n', left3, right3);
%fprintf('%s %s\n', left2, right2);
%fprintf('%s %s\n', left1, right1);

end

header{1} = [left1 right1];
header{2} = [left2 right2];
header{3} = [left3 right3];

