% pParse_h8_IL sets up a model for .... ,
% plus closing canonical basepairs on either side
% It is for demonstration purposes.

clear Node

n=1;                                            % current node
  Node(n).type      = 'Initial';                % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Node(n).lpar      = 0.05;                     % left insertion parameter
  Node(n).rpar      = 0.05;                     % right insertion parameter

n=2;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(1,3,2,0.01);
  Node(n).P         = ones(17,1)*Score;         % state to state transitions
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [1.00*ones(16,1); 0];     % right insertion parameters

n=3;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(4,1,1,0.01);
  Node(n).P         = ones(17,1)*Score;         % state to state transitions
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [0.01*ones(16,1); 0];     % right insertion parameters

n=4;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(-4,2,1,0.01);
  Node(n).P         = ones(17,1)*Score;         % state to state transitions
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [0.01*ones(16,1); 0];     % right insertion parameters

n=5;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(-4,1,4,0.01);
  Node(n).P         = ones(17,1)*Score;         % state to state transitions
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [0.01*ones(16,1); 0];     % right insertion parameters

n=6;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(-4,1,2,0.01);
  Node(n).P         = ones(17,1)*Score;         % state to state transitions
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [0.01*ones(16,1); 0];     % right insertion parameters

n=7;
  Node(n).type      = 'Basepair';               % node type
  Node(n).nextnode  = n+1;                      % index of next node in tree
  Score             = pIsoScore(1,2,3,0.01);
  Node(n).P         = ones(17,1)*Score;         % state to state transitions
  Node(n).PIns	    = Score;                    % when no previous state
  Node(n).lpar      = [0.01*ones(16,1); 0];     % left insertion parameters
  Node(n).rpar      = [0.01*ones(16,1); 0];     % right insertion parameters

n=8;                                            % current node
  Node(n).type      = 'Hairpin';                % node type
  Node(n).subtype   = 'AAAA';                   % pretend 'AAAA' loop
  Node(n).nextnode  = Inf;                      % index of next node in tree
  Node(n).P         = ones(17,1);               % state to state transitions
  Node(n).PIns      = 1;                        % when no previous state

% ----------------------------------------- End of user-specified part

% ----------------------------------------- Specify sequences to parse

Sequence          = pReadFASTA('h8IL','Crenarchaeota_Acidianus_infernus','GAUAACAAAAGCUAAUC');

Node(1).Sequence = 'GAUAACAAAAGCUAAUC';

a = strfind(Sequence(1).Fasta(Sequence(1).FastaIndex),Node(1).Sequence);
b = a + length(Node(1).Sequence) - 1;

Sequence(1).Start = Sequence(1).FastaIndex(a);          % starting column
Sequence(1).End   = Sequence(1).FastaIndex(b);          % ending column


% ----------------------------------------- Parse sequences, display alignment

numtodo = 100;

k = 1;

for j=k:min(length(Sequence),(k+numtodo-1)),
  [Node,Sequence] = pParseSequences(Node,Sequence,j,j);
  k = j;
  pDisplayMultipleAlignment(Node,Sequence);
  drawnow
end


