%mColorAlignment13.m

if ~exist('mask13','var')
    mMaskMaker
end
%now mask13 is the 3D mask, and Sequences contains the sequence info.
%We just need to build html with those sequences colored by IM according to mask13 and BP identity.

if ~exist('Bases','var'), Bases = {'A' 'C' 'G' 'U'}; end

Color = zeros(length(Sequences(:,1)),length(Sequences(1,:)));
ColorHTML{length(Sequences(:,1)),length(Sequences(1,:))} = [];
IsosterCompar=zeros(length(InputData(:,1)));

for n = length(InputData(:,1)):-1:1 %In case of triplets, this should give priority to interactions listed earlier (usually cWW)
    for a=1:4,if strcmp(Bases(a),PosArray(OrgInd(n),1,n)),break,end,end
    for b=1:4,if strcmp(Bases(b),PosArray(OrgInd(n),2,n)),break,end,end
    IsosterCompar(n) = M(a,b,round(abs(Table(n))));%This will set the isostericity value for the BP in the crystal structure (actually, from the organism chosen in mGetPositions, which usually corresponds to the crystal structure)

    for s = 1:length(Sequences(:,1))
        A = Sequences(s,Univ(InputData(n,1)));
        B = Sequences(s,Univ(InputData(n,2)));
        a = mNT2num(A);
        b = mNT2num(B);
        
        sc = abs(M(a,b,round(abs(Table(n)))) - IsosterCompar(n));
        sc = round(10*sc)/10; %to solve the problem of infinitesimal artificial dicrepancies with numbers
        if Table(n)~=14
        [colcode,colcodeHTML] = mColorCode(sc,a,b,M(a,b,round(abs(Table(n)))));
        else
            colcode=10;
            colcodeHTML='000000';
        end
        Color(s,Univ(InputData(n,1))) = colcode;
        Color(s,Univ(InputData(n,2))) = colcode;
        ColorHTML{s,Univ(InputData(n,1))} = colcodeHTML;
        ColorHTML{s,Univ(InputData(n,2))} = colcodeHTML;
   end
end

% for i=1:length(Color(:,1))
%     for j=1:length(Color(1,:))
%         fprintf('%g',Color(i,j));
%     end
%     fprintf('\n');
% end
