%mColorAlignment13_WriteHTML.m

mColorAlignment13

OutputColAlign   =   strcat(OutputPath,PositionList,'_',FastaFilename,'_AlignViewer.html');
fidOUTColAlign   =   fopen(OutputColAlign,'w+');

fprintf('%s\n','Creating the "_AlignViewer.html" file ...');

fprintf(fidOUTColAlign,'%s\n','<html>');
fprintf(fidOUTColAlign,'%s\n','<head>');
fprintf(fidOUTColAlign,'%s\n','<title>Ribostral Alignment Viewer</title>');
fprintf(fidOUTColAlign,'%s\n','</head>');
fprintf(fidOUTColAlign,'%s\n','<body>');


fprintf(fidOUTColAlign,'%s','<div align="center"><strong>Alignment file: </strong>');
fprintf(fidOUTColAlign,'%s',FastaFilename);
fprintf(fidOUTColAlign,'%s\n','</div>');
fprintf(fidOUTColAlign,'%s','<div align="center"><strong>BP list: </strong>');
fprintf(fidOUTColAlign,'%s',PositionList);
fprintf(fidOUTColAlign,'%s\n','</div></strong>');

fprintf(fidOUTColAlign,'%s','<div align="center"><strong>');
fprintf(fidOUTColAlign,'%s','BP family symbols used in 13D mask');
fprintf(fidOUTColAlign,'%s\n','</strong>');
fprintf(fidOUTColAlign,'%s',' (non-symmetric BPs must be read from UPPERCASE to lowercase to reflect edges in the order W,H,S):');
fprintf(fidOUTColAlign,'%s\n','</div>');

fprintf(fidOUTColAlign,'%s','<div align="center">');
fprintf(fidOUTColAlign,'%s %s %s %s %s %s %s %s %s %s %s %s %s %s',...
'cWW=ab;',...
'tWW=cd;',...
'cWH=ef;',...
'tWH=gh;',...
'cWS=ij;',...
'tWS=kl;',...
'cHH=mn;',...
'tHH=op;',...
'cHS=qr;',...
'tHS=st;',...
'cSS=uv;',...
'tSs=wx;',...
'bif=yz;',...
'unspecified=?!');
fprintf(fidOUTColAlign,'%s\n','</div>');

fprintf(fidOUTColAlign,'%s','<div align="center"><strong>');
fprintf(fidOUTColAlign,'%s','Color Codes:');
fprintf(fidOUTColAlign,'%s\n','</strong>');

fprintf(fidOUTColAlign,'%s%s%s','<font color="#','000000','">no info;  </font>');

[colcode,colcodeHTML] = mColorCode(0,5,1,1);  fprintf(fidOUTColAlign,'%s%s%s','<font color="#',colcodeHTML,'">one gap;  </font>');
[colcode,colcodeHTML] = mColorCode(0,5,5,1);  fprintf(fidOUTColAlign,'%s%s%s','<font color="#',colcodeHTML,'">both gaps;  </font>');
[colcode,colcodeHTML] = mColorCode(0,1,1,1);  fprintf(fidOUTColAlign,'%s%s%s','<font color="#',colcodeHTML,'">Isosteric;  </font>');
[colcode,colcodeHTML] = mColorCode(.1,1,1,1); fprintf(fidOUTColAlign,'%s%s%s','<font color="#',colcodeHTML,'">NearIsosteric;  </font>');
[colcode,colcodeHTML] = mColorCode(1,1,1,1);  fprintf(fidOUTColAlign,'%s%s%s','<font color="#',colcodeHTML,'">Heterosteric;  </font>');
[colcode,colcodeHTML] = mColorCode(0,1,1,0);  fprintf(fidOUTColAlign,'%s%s%s','<font color="#',colcodeHTML,'">Forbidden.  </font></div>');
% both gaps,    colcodeHTML = '333333';
% one gap,     colcodeHTML = '999999';
% Forbidden,    colcodeHTML = 'CC0000';
% Isosteric,    colcodeHTML = '00CC00';
% NearIsosteric,    colcodeHTML = 'FFFF00';
% Heterosteric,    colcodeHTML = 'CC9900';


fprintf(fidOUTColAlign,'%s\n','<table width="100%" cellspacing="0" bordercolor="#000000">');

fprintf(fidOUTColAlign,'%s\n','<tr bgcolor="#000000">');
fprintf(fidOUTColAlign,'%s\n','<td><font color="#FFFFFF" face="Courier, mono">Universal Numbers</font></td>');
fprintf(fidOUTColAlign,'%s\n','<td><div align="center"><font color="#FFFFFF" face="Courier, mono">UN</font></div></td>');
fprintf(fidOUTColAlign,'%s','<td><font color="#FFFFFF" face="Courier, mono">');

c=0;
fprintf(fidOUTColAlign,'%g',c+1);
while c<=length(Sequences(1,:))%length of "each" sequence
    if      c<100,
        fprintf(fidOUTColAlign,'%s','...|....');
    elseif  c<1000,
        fprintf(fidOUTColAlign,'%s', '..|....');
    elseif  c<10000,
        fprintf(fidOUTColAlign,'%s',  '.|....');
    elseif  c<100000,
        fprintf(fidOUTColAlign,'%s',   '|....');
    end
    c=c+10;
    if (c/10)==fix(c/10)
       fprintf(fidOUTColAlign,'%g',c); 
    end
end
% % fprintf(fidOUTColAlign,'%s',SeqLadder(1:length(Sequences(1,:))));

fprintf(fidOUTColAlign,'%s','</font></td>');
fprintf(fidOUTColAlign,'%s\n','</tr>');

fprintf(fidOUTColAlign,'%s\n','<tr bgcolor="#000000">');
fprintf(fidOUTColAlign,'%s%s%s\n','<td><font color="#FFFFFF" face="Courier, mono">',FastaOrganismNames{OrgInd(1)},' Local Numbers</font></td>');
fprintf(fidOUTColAlign,'%s\n','<td><div align="center"><font color="#FFFFFF" face="Courier, mono">LN</font></div></td>');
fprintf(fidOUTColAlign,'%s','<td nowrap><font color="#FFFFFF" face="Courier, mono">');
lc=0;
for i=1:length(Sequences(OrgInd(1),:))
    if ~strcmp((Sequences(OrgInd(1),i)),'-')
        lc=lc+1;
        if fix(lc/10)==lc/10
            if lc<100
                fprintf(fidOUTColAlign,'%g',lc/10);
            elseif lc<1000
                fprintf(fidOUTColAlign,'%g',rem(lc,100)/10);
            elseif lc<10000
                fprintf(fidOUTColAlign,'%g',rem(rem(lc,1000),100)/10);
            end
        else fprintf(fidOUTColAlign,'%s','.');
        end
    else fprintf(fidOUTColAlign,'%s','-');
    end
end
fprintf(fidOUTColAlign,'%s','</font></td>');
fprintf(fidOUTColAlign,'%s\n','</tr>');

fprintf(fidOUTColAlign,'%s\n','<tr bgcolor="#000000">');
fprintf(fidOUTColAlign,'%s\n','<td><font color="#FFFFFF" face="Courier, mono">13D Directional Mask</font></td>');
fprintf(fidOUTColAlign,'%s\n','<td><div align="center"><font color="#FFFFFF" face="Courier, mono">M13</font></div></td>');
fprintf(fidOUTColAlign,'%s','<td><font color="#FFFFFF" face="Courier, mono">');
fprintf(fidOUTColAlign,'%s',mask13);
fprintf(fidOUTColAlign,'%s','</font></td>');
fprintf(fidOUTColAlign,'%s\n','</tr>');

fprintf(fidOUTColAlign,'%s\n','<tr bgcolor="#000000">');
fprintf(fidOUTColAlign,'%s\n','<td nowrap><font color="#FFFFFF" face="Courier, mono">3D Mask [brackets not nested]</font></td>');
fprintf(fidOUTColAlign,'%s\n','<td><div align="center"><font color="#FFFFFF" face="Courier, mono">M3</font></div></td>');
fprintf(fidOUTColAlign,'%s','<td><font color="#FFFFFF" face="Courier, mono">');
fprintf(fidOUTColAlign,'%s',mask3);
fprintf(fidOUTColAlign,'%s','</font></td>');
fprintf(fidOUTColAlign,'%s\n','</tr>');

fprintf(fidOUTColAlign,'%s\n','<tr bgcolor="#000000">');
fprintf(fidOUTColAlign,'%s\n','<td><font color="#FFFFFF" face="Courier, mono">2D Mask (nested)</font></td>');
fprintf(fidOUTColAlign,'%s\n','<td><div align="center"><font color="#FFFFFF" face="Courier, mono">M2</font></div></td>');
fprintf(fidOUTColAlign,'%s','<td><font color="#FFFFFF" face="Courier, mono">');
fprintf(fidOUTColAlign,'%s',mask2);
fprintf(fidOUTColAlign,'%s','</font></td>');
fprintf(fidOUTColAlign,'%s\n','</tr>');

DL=1;
PercentDoneLast=-1;
for S=1:length(Sequences(:,1))       %number of sequences

    PercentDone = round(S*100/length(Sequences(:,1)));
    if PercentDone ~= PercentDoneLast, %Only print percent counter in case it changes, to save time
        PercentDoneLast = PercentDone;
        if PercentDone==0,  fprintf('\n\n\n\n\n'); end
        fprintf('\b\b\b\b\b%3g%s',   PercentDone,' %');
        %if PercentDone<11,  fprintf('\b\b\b%g%s',   PercentDone,' %');
        %else,               fprintf('\b\b\b\b%g%s', PercentDone,' %'); end
    end
    %if round(S/100)==S/100,fprintf('%g%s\n',S,'Seqs'),end

    if S == DomainLimits(DL)+1 %%%This is needed to restart colors at each new domain
        rem =   0;
        NS = DomainLimits(DL+1)- DomainLimits(DL);
        DL  =   DL+1;
    end
    rem=rem+1;
    
    fprintf(fidOUTColAlign,'%s\n','<tr>');
  
    fprintf(fidOUTColAlign,'%s','<td nowrap bgcolor="#666666"><font color="#');
    
    R = round(255*rem/NS);      G = round(0  );     B = round(255*rem/NS);
        
    if R>16, fprintf(fidOUTColAlign,'%s',dec2hex(R)); else fprintf(fidOUTColAlign,'%s%s','0',dec2hex(R)); end
    if G>16, fprintf(fidOUTColAlign,'%s',dec2hex(G)); else fprintf(fidOUTColAlign,'%s%s','0',dec2hex(G)); end
    if B>16, fprintf(fidOUTColAlign,'%s',dec2hex(B)); else fprintf(fidOUTColAlign,'%s%s','0',dec2hex(B)); end
    
    fprintf(fidOUTColAlign,'%s\n','" face="Courier, mono">');
    fprintf(fidOUTColAlign,'%s\n',FastaOrganismNames{S}); %(1:16)
	fprintf(fidOUTColAlign,'%s\n','</font></td>');

    fprintf(fidOUTColAlign,'%s','<td bgcolor="#000000"><div align="center"><font color="#FFFFFF" face="Courier, mono">');
    fprintf(fidOUTColAlign,'%g',S);
    fprintf(fidOUTColAlign,'%s','</font></div></td>');
    
    fprintf(fidOUTColAlign,'%s\n','<td nowrap><font face="Courier, mono">');
    for c=1:length(Sequences(1,:))   %length of each sequence
        fprintf(fidOUTColAlign,'%s','<font color="#');
        
%         [r g b] = mSetColumnColors(S,c,ChosenDomains,DomainLimits,ListUnivPos,NormalizedScores);
        
%         R = round(r*255);    G = round(g*255);    B = round(b*255);
        

%         if R==0,
%             fprintf(fidOUTColAlign,'%s%s','00');
%         elseif R<16, fprintf(fidOUTColAlign,'%s%s','0',dec2hex(R));
%         else fprintf(fidOUTColAlign,'%s',dec2hex(R));
%         end
%         if G==0,
%             fprintf(fidOUTColAlign,'%s%s','00');
%         elseif G<16, fprintf(fidOUTColAlign,'%s%s','0',dec2hex(G));
%         else fprintf(fidOUTColAlign,'%s',dec2hex(G));
%         end
%         if B==0,
%             fprintf(fidOUTColAlign,'%s%s','00');
%         elseif B<16, fprintf(fidOUTColAlign,'%s%s','0',dec2hex(B));
%         else fprintf(fidOUTColAlign,'%s',dec2hex(B));
%         end

        fprintf(fidOUTColAlign,'%s',ColorHTML{S,c}); %%%%%%%%%%%% THIS IS THE HEART, MADE IN mColorAlignment13 %%%%%%%%%%%


        fprintf(fidOUTColAlign,'%s','">');
        fprintf(fidOUTColAlign,'%s',Sequences(S,c));
        fprintf(fidOUTColAlign,'%s','</font>');
    end
    fprintf(fidOUTColAlign,'%s\n','</font></td>');
  fprintf(fidOUTColAlign,'%s\n','</tr>');
end
  
fprintf(fidOUTColAlign,'%s\n','</table>');

fprintf(fidOUTColAlign,'%s\n','</body>');
fprintf(fidOUTColAlign,'%s\n','</html>');

fclose(fidOUTColAlign);

% fprintf('\n%s\n%s\n','html printed to:',OutputColAlign);

% open(OutputColAlign)