%mColorCode(sc,a,b).m

function [colcode,colcodeHTML] = mColorCode(sc,a,b,M)

if      a==5 && b==5
    colcode = 6; %Both gaps,        Dark gray ... no LIGHT GRAY
    colcodeHTML = '999999';
elseif  a==5 || b==5
    colcode = 5; %1 gap,            Light gray ... no DARK GRAY
    colcodeHTML = '555555';
elseif  M==0
    colcode = 5; %Forbidden,        Red
    colcodeHTML = 'FF0000';
elseif  sc==0;
    colcode = 1; %Isosteric,        Green
    colcodeHTML = '00CC00';
elseif  sc<=0.2;
    colcode = 2; %NearIsosteric,    Yellow... no BLUE
    colcodeHTML = '0066CC';
elseif  sc>0.2;
    colcode = 3; %Heterosteric,     Orange... no PINK
    colcodeHTML = 'FF00FF';
end
%Note: The variable Color=colcode (in the master mColorAlignment13) will stay zero otherwise, giving it Black color
