%mColoredSequenceTableHTML_Columns.m
NormalizedScores=(Score+100)/200; %To be used in mSetColumnColors.m
ListUnivPos=Univ(InputData);     %To be used in mSetColumnColors.m

%SeqLadder = '1...|....10...|....20...|....30...|....40...|....50...|....60...|....70...|....80...|....90...|....100';

mMaskMaker      %This will create the mask for the alignment based on the Positions xls file
tic

% This is done in mMaskMaker (it ofcourse checks if it present or not, but still it is redundant)
% if ~exist('OutputPath','var')
%     mkdir('../../Output');
%     OrigDir=cd;
%     if ispc ==1 %ispc returns 1 if this is run on a PC (Windows)
%         ind= findstr('\',OrigDir);  %Doesn't work on MAC
%     else
%         ind= findstr('/',OrigDir);  %Works on MAC
%     end
%     OutputPath=strcat(OrigDir(1:ind(end-1)),'Output\');
% end


OutputColSeqTableHTML   =   strcat(OutputPath,PositionList,'_',FastaFilename,'_ALIGNMENT_columns.html');
fidOUTColSeqTableHTML   =   fopen(OutputColSeqTableHTML,'w+');

fprintf('\n%s\n','Creating the mColoredSequenceTableHTML_Columns output file ...');

fprintf(fidOUTColSeqTableHTML,'%s\n','<html>');
fprintf(fidOUTColSeqTableHTML,'%s\n','<head>');
fprintf(fidOUTColSeqTableHTML,'%s\n','<title>Mokdad sequence viewer</title>');
fprintf(fidOUTColSeqTableHTML,'%s\n','</head>');
fprintf(fidOUTColSeqTableHTML,'%s\n','<body>');


fprintf(fidOUTColSeqTableHTML,'%s','<div align="center"><strong>');
fprintf(fidOUTColSeqTableHTML,'%s',OutputColSeqTableHTML);
fprintf(fidOUTColSeqTableHTML,'%s\n','</strong></div>');

fprintf(fidOUTColSeqTableHTML,'%s\n','<table width="100%" cellspacing="0" bordercolor="#000000">');


fprintf(fidOUTColSeqTableHTML,'%s\n','<tr bgcolor="#000000">');
fprintf(fidOUTColSeqTableHTML,'%s\n','<td><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>Seq Name</strong></font></td>');
fprintf(fidOUTColSeqTableHTML,'%s\n','<td><div align="center"><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>NO</strong></font></div></td>');
fprintf(fidOUTColSeqTableHTML,'%s','<td><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>');

c=0;
fprintf(fidOUTColSeqTableHTML,'%g',c+1);
while c<=length(Sequences(1,:))%length of "each" sequence
    if      c<100,
        fprintf(fidOUTColSeqTableHTML,'%s','...|....');
    elseif  c<1000,
        fprintf(fidOUTColSeqTableHTML,'%s', '..|....');
    elseif  c<10000,
        fprintf(fidOUTColSeqTableHTML,'%s',  '.|....');
    elseif  c<100000,
        fprintf(fidOUTColSeqTableHTML,'%s',   '|....');
    end
    c=c+10;
    if (c/10)==fix(c/10)
       fprintf(fidOUTColSeqTableHTML,'%g',c); 
    end
end
% % fprintf(fidOUTColSeqTableHTML,'%s',SeqLadder(1:length(Sequences(1,:))));

fprintf(fidOUTColSeqTableHTML,'%s','</strong></font></td>');
fprintf(fidOUTColSeqTableHTML,'%s\n','</tr>');

fprintf(fidOUTColSeqTableHTML,'%s\n','<tr bgcolor="#000000">');
fprintf(fidOUTColSeqTableHTML,'%s\n','<td><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>13D Directional Mask</strong></font></td>');
fprintf(fidOUTColSeqTableHTML,'%s\n','<td><div align="center"><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>M13</strong></font></div></td>');
fprintf(fidOUTColSeqTableHTML,'%s','<td><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>');
fprintf(fidOUTColSeqTableHTML,'%s',mask13);
fprintf(fidOUTColSeqTableHTML,'%s','</strong></font></td>');
fprintf(fidOUTColSeqTableHTML,'%s\n','</tr>');

fprintf(fidOUTColSeqTableHTML,'%s\n','<tr bgcolor="#000000">');
fprintf(fidOUTColSeqTableHTML,'%s\n','<td><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>3D Mask (beta?)</strong></font></td>');
fprintf(fidOUTColSeqTableHTML,'%s\n','<td><div align="center"><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>M3</strong></font></div></td>');
fprintf(fidOUTColSeqTableHTML,'%s','<td><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>');
fprintf(fidOUTColSeqTableHTML,'%s',mask3);
fprintf(fidOUTColSeqTableHTML,'%s','</strong></font></td>');
fprintf(fidOUTColSeqTableHTML,'%s\n','</tr>');

fprintf(fidOUTColSeqTableHTML,'%s\n','<tr bgcolor="#000000">');
fprintf(fidOUTColSeqTableHTML,'%s\n','<td><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>2D Mask</strong></font></td>');
fprintf(fidOUTColSeqTableHTML,'%s\n','<td><div align="center"><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>M2</strong></font></div></td>');
fprintf(fidOUTColSeqTableHTML,'%s','<td><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>');
fprintf(fidOUTColSeqTableHTML,'%s',mask2);
fprintf(fidOUTColSeqTableHTML,'%s','</strong></font></td>');
fprintf(fidOUTColSeqTableHTML,'%s\n','</tr>');

DL=1;
PercentDoneLast=-1;
for S=1:length(Sequences(:,1))       %number of sequences

    PercentDone = round(S*100/length(Sequences(:,1)));
    if PercentDone ~= PercentDoneLast, %Only print percent counter in case it changes, to save time
        PercentDoneLast = PercentDone;
        %if PercentDone==0,  fprintf('\n\n\n'); end
        if PercentDone==0,  fprintf('\n\n\n\n\n'); end
        fprintf('\b\b\b\b\b%3g%s',   PercentDone,' %');
        %if PercentDone<11,  fprintf('\b\b\b%g%s',   PercentDone,' %');
        %else,               fprintf('\b\b\b\b%g%s', PercentDone,' %'); end
    end
    %if round(S/100)==S/100,fprintf('%g%s\n',S,'Seqs'),end

    if S == DomainLimits(DL)+1 %%%This is needed to restart colors at each new domain
        rem =   0;
        NS = DomainLimits(DL+1)- DomainLimits(DL);
        DL  =   DL+1;
    end
    rem=rem+1;
    
    fprintf(fidOUTColSeqTableHTML,'%s\n','<tr>');
  
    fprintf(fidOUTColSeqTableHTML,'%s','<td nowrap bgcolor="#666666"><font color="#');
    
    R = round(255*rem/NS);      G = round(0  );     B = round(255*rem/NS);


        
    if R>16, fprintf(fidOUTColSeqTableHTML,'%s',dec2hex(R)); else fprintf(fidOUTColSeqTableHTML,'%s%s','0',dec2hex(R)); end
    if G>16, fprintf(fidOUTColSeqTableHTML,'%s',dec2hex(G)); else fprintf(fidOUTColSeqTableHTML,'%s%s','0',dec2hex(G)); end
    if B>16, fprintf(fidOUTColSeqTableHTML,'%s',dec2hex(B)); else fprintf(fidOUTColSeqTableHTML,'%s%s','0',dec2hex(B)); end
    
    fprintf(fidOUTColSeqTableHTML,'%s\n','" face="Courier New, Courier, mono">');
    fprintf(fidOUTColSeqTableHTML,'%s\n',FastaOrganismNames{S}); %(1:16)
	fprintf(fidOUTColSeqTableHTML,'%s\n','</font></td>');

    fprintf(fidOUTColSeqTableHTML,'%s','<td bgcolor="#000000"><div align="center"><font color="#FFFFFF" face="Courier New, Courier, mono"><strong>');
    fprintf(fidOUTColSeqTableHTML,'%g',S);
    fprintf(fidOUTColSeqTableHTML,'%s','</strong></font></div></td>');
    
    fprintf(fidOUTColSeqTableHTML,'%s\n','<td nowrap><font face="Courier New, Courier, mono">');
    for c=1:length(Sequences(1,:))   %length of each sequence
        fprintf(fidOUTColSeqTableHTML,'%s','<font color="#');
        
        [r g b] = mSetColumnColors(S,c,ChosenDomains,DomainLimits,ListUnivPos,NormalizedScores);
        
        R = round(r*255);    G = round(g*255);    B = round(b*255);
        
        if R==0,
            fprintf(fidOUTColSeqTableHTML,'%s%s','00');
        elseif R<16, fprintf(fidOUTColSeqTableHTML,'%s%s','0',dec2hex(R));
        else fprintf(fidOUTColSeqTableHTML,'%s',dec2hex(R));
        end
        if G==0,
            fprintf(fidOUTColSeqTableHTML,'%s%s','00');
        elseif G<16, fprintf(fidOUTColSeqTableHTML,'%s%s','0',dec2hex(G));
        else fprintf(fidOUTColSeqTableHTML,'%s',dec2hex(G));
        end
        if B==0,
            fprintf(fidOUTColSeqTableHTML,'%s%s','00');
        elseif B<16, fprintf(fidOUTColSeqTableHTML,'%s%s','0',dec2hex(B));
        else fprintf(fidOUTColSeqTableHTML,'%s',dec2hex(B));
        end

        fprintf(fidOUTColSeqTableHTML,'%s','">');
        fprintf(fidOUTColSeqTableHTML,'%s',Sequences(S,c));
        fprintf(fidOUTColSeqTableHTML,'%s','</font>');
    end
    fprintf(fidOUTColSeqTableHTML,'%s\n','</font></td>');
  fprintf(fidOUTColSeqTableHTML,'%s\n','</tr>');
end
  
fprintf(fidOUTColSeqTableHTML,'%s\n','</table>');

fprintf(fidOUTColSeqTableHTML,'%s\n','</body>');
fprintf(fidOUTColSeqTableHTML,'%s\n','</html>');

fclose(fidOUTColSeqTableHTML);

fprintf('\n%s\n%s\n','html printed to:',OutputColSeqTableHTML);

toc
% open(OutputColSeqTableHTML)