%mSetColumnColors.m
%This should be run after mMutualCounter_IF, where the Score for each BP (couple of columns) is calculated

function [r g b] = mSetColumnColors(S,c,ChosenDomains,DomainLimits,ListUnivPos,NormalizedScores)
%S is number of sequences
%c is length of current sequence
%[r g b] each should be between 0 & 1, because later this will be done to each: R = round(r*255);
%The next two variables were defined in the master program mColoredSequenceTableHTML:
%   NormalizedScores=Score+100)/200;
%   ListUnivPos=Univ(InputData);

for P=ChosenDomains
    %x=find(1<DomainLimits==1)
    if (S > DomainLimits(P)) && (S <= DomainLimits(P+1))
        %if c==ListUnivPos
        index   =   [find(ListUnivPos(:,1)==c)' find(ListUnivPos(:,2)==c)'];
        if ~isempty(index)
            %sum(NormalizedScores(index,P))/length(NormalizedScores(index,P));
            r   =   NormalizedScores(index,P);
            if r(1)<.6 && r(1)>.4
                g   =   NormalizedScores(index,P);
            else g=0;
            end
            if r<.4
                b   =   1-NormalizedScores(index,P);
            else b=0;
            end
            r=sum(r)/length(r);
            g=sum(g)/length(g);
            b=sum(b)/length(b);
        else
            r=0; g=0; b=0;
        end
    end
end
