function DisplayImage(FigureFilename,DisplayTitle,CloseRequest,PrintRequest)

if nargin ==1
    DisplayTitle='';
    CloseRequest=0;
    PrintRequest=0;
end
if nargin ==2
    CloseRequest=0;
    PrintRequest=0;
end
if nargin ==1
    PrintRequest=0;
end

f = figure('NumberTitle','off','name',DisplayTitle,'MenuBar','none');

if CloseRequest==1
   set(f,'ButtonDownFcn','close','WindowButtonDownFcn','close','KeyPressFcn','close');
end

if PrintRequest==1
    uimenu('Label','Print','Callback',{@PrintImage,f}); %This runs a separate function, not subfunction
    e=80;
else e=50;
end
    
im = imread(FigureFilename);
imsz = size(im);
imw = imsz(2);
imh = imsz(1);

set(0,'Units','pixels');
scrsz = get(0,'ScreenSize');
scw = scrsz(3);
sch = scrsz(4);

if (scw >= imw+e) && (sch >= imh+e)
    width  = imw;
    height = imh;
elseif scw < imw+e
    width  = scw-e;
    height = imh*width/imw;
    if sch < height+e
        width  = width*(sch-e)/height;
        height = sch-e;
    end
elseif sch < imh+e
    height = sch-e;
    width  = imw*height/imh;
    if scw < width+e
        height = height*(scw-e)/width;
        width  = scw-e;
    end
end
set(f  ,'Units','Pixels','Position',[(scw-imw)/2 (sch-imh)/2 width height]);
set(gca,'Units','Pixels','Position',[0 0 width height]);

image(im);

axis off
