function varargout = mFastaExtractor_multipleGUI(varargin)
% MFASTAEXTRACTOR_MULTIPLEGUI M-file for mFastaExtractor_multipleGUI.fig
%      MFASTAEXTRACTOR_MULTIPLEGUI, by itself, creates a new MFASTAEXTRACTOR_MULTIPLEGUI or raises the existing
%      singleton*.
%
%      H = MFASTAEXTRACTOR_MULTIPLEGUI returns the handle to a new MFASTAEXTRACTOR_MULTIPLEGUI or the handle to
%      the existing singleton*.
%
%      MFASTAEXTRACTOR_MULTIPLEGUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MFASTAEXTRACTOR_MULTIPLEGUI.M with the given input arguments.
%
%      MFASTAEXTRACTOR_MULTIPLEGUI('Property','Value',...) creates a new MFASTAEXTRACTOR_MULTIPLEGUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before mFastaExtractor_multipleGUI_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to mFastaExtractor_multipleGUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help mFastaExtractor_multipleGUI

% Last Modified by GUIDE v2.5 11-Nov-2005 13:13:07

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @mFastaExtractor_multipleGUI_OpeningFcn, ...
                   'gui_OutputFcn',  @mFastaExtractor_multipleGUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before mFastaExtractor_multipleGUI is made visible.
function mFastaExtractor_multipleGUI_OpeningFcn(hObject, eventdata, handles, varargin)

load('Preferences.mat');%This reads the last settings from the previous session
GUI_dimentions=get(hObject, 'position');%Used to extract the DIMENTIONS (the 3rd and 4th component) in case some changes to the GUI shape were made...
FastaExtractor_position=[FastaExtractor_position(1),FastaExtractor_position(2),GUI_dimentions(3),GUI_dimentions(4)];
save('Preferences.mat','Audio','ShowTotals','ShowNs','ShowGaps','ShowExpected','Rounding','main_position','preferences_position','OneByOne_position','OneByOne_PercentsCounts','MasterParser_position','FastaExtractor_position','FastaFixer_position','SeqViewerYES','GUspecialYES');
set(hObject, 'position', FastaExtractor_position);

passed  =   varargin{1};      	%this is how you import from the main GUI (mMutualCounterGUI)
if length(passed.DomainNames)>1
    tempDomainNames = [passed.DomainNames,'All'];
else
    tempDomainNames = passed.DomainNames;
end

set(handles.DomainsToExtractPopupmenu   ,'String',tempDomainNames)
set(handles.DomainsToExtractPopupmenu   ,'Value',length(tempDomainNames))

set(handles.RefOrganismNamePopupmenu    ,'String',passed.FastaOrganismNames)
if isfield(passed,'OrgInd')
    set(handles.RefOrganismNamePopupmenu    ,'Value',passed.OrgInd(1))
end

handles.passed = passed;
handles.output = hObject;
guidata(hObject, handles);


function varargout = mFastaExtractor_multipleGUI_OutputFcn(hObject, eventdata, handles) 
varargout{1} = handles.output;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function DomainsToExtractPopupmenu_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function DomainsToExtractPopupmenu_Callback(hObject, eventdata, handles)


function IgnoreTopOrganismsPopupmenu_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function IgnoreTopOrganismsPopupmenu_Callback(hObject, eventdata, handles)


function RefOrganismNamePopupmenu_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function RefOrganismNamePopupmenu_Callback(hObject, eventdata, handles)
FastaOrganismNames = handles.passed.FastaOrganismNames;
o=get(handles.RefOrganismNamePopupmenu,'Value');
set(handles.RefOrganismNameText,'String',FastaOrganismNames{o})

function RefOrganismNameText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function RefOrganismNameText_Callback(hObject, eventdata, handles)
FastaOrganismNames = handles.passed.FastaOrganismNames; %these should be imported from the main GUI, otherwise do GetFasta first and pass>>>
RefOrganismNameText = {get(handles.RefOrganismNameText,'String')};
for s = 1:length(FastaOrganismNames) %this loop looks for the particular organism from which you want to give Local numbers
    if strfind(lower(FastaOrganismNames{s}),lower(RefOrganismNameText{1}))
        OrgInd = s;
        break %This will break this loop at the first hit of the organism name.
    end
end
if exist('OrgInd','var')
set(handles.RefOrganismNamePopupmenu,'Value',OrgInd);%%%OrgInd is taken from mGetUnivFromAnyFasta
else
    fprintf('%s%s%s\n','The requested organism, ',RefOrganismNameText{1},', could not be found');
    set(handles.RefOrganismNameText,'String','Universal')
end
guidata(hObject, handles);


function InputText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function InputText_Callback(hObject, eventdata, handles)

function Browse_Callback(hObject, eventdata, handles)
if ispc
    [ILList,ILListPath] = uigetfile({'*.txt','*.txt';'*.*','*.*'},'Pick text file containing NT numbers to be extracted',handles.passed.FastaPath);
else
    [ILList,ILListPath] = uigetfile({'*.txt','*.txt'},'Pick text file containing NT numbers to be extracted',handles.passed.FastaPath);
end
if strcmp(class(ILList),'char') %In case the prompt is not cancelled
    file=strcat(ILListPath,ILList);
    [LocPosName, LocPosInput] = textread(file,'%s\t%s');
    set(handles.InputText,'String',file);
else
    fprintf('%s\n','Browsing for a text file with the NT numbers to extract was cancelled by user')
end
guidata(hObject,handles)


function RUN_Callback(hObject, eventdata, handles)
FastaOrganismNames  =   handles.passed.FastaOrganismNames;
Sequences           =   handles.passed.Sequences;
DomainNames         =   handles.passed.DomainNames;
DomainLimits        =   handles.passed.DomainLimits;
FastaPath           =   handles.passed.FastaPath;
FastaFilename       =   handles.passed.FastaFilename;
if ~isempty(handles.passed.InputData)
    InputData       =   handles.passed.InputData;
    InputText       =   handles.passed.InputText;
    PositionList    =   handles.passed.PositionList;
    PositionPath    =   handles.passed.PositionPath;
    BPlist          =   strcat(PositionPath,PositionList);
else
    BPlist              =   [];
end

DomainsToExtract        = get(handles.DomainsToExtractPopupmenu,'Value');
str                     = get(handles.DomainsToExtractPopupmenu,'String');
DomainNamesToExtract    = str{DomainsToExtract};

OrganismName            = {get(handles.RefOrganismNameText,'String')};
PREIgnoreTopOrganisms   = get(handles.IgnoreTopOrganismsPopupmenu,'String');
x                       = get(handles.IgnoreTopOrganismsPopupmenu,'Value');
IgnoreTopOrganisms      = str2num(PREIgnoreTopOrganisms{x});

InputText       = get(handles.InputText,'String');
if strfind(InputText, filesep),
    [LocPosName, LocPosInput] = textread(InputText,'%s\t%s');
else LocPosName = {InputText};
    LocPosInput = {InputText};
end

mFastaExtractor_multiple_forGUI


% --- Executes during object deletion, before destroying properties.
function FigFastaExtractor_DeleteFcn(hObject, eventdata, handles)
load('Preferences.mat');%This reads the last settings from the previous session
FastaExtractor_position=get(hObject, 'position');  %Updated here just before closing, this way, the next time this GUI will open in the same location it was closed in
save('Preferences.mat','Audio','ShowTotals','ShowNs','ShowGaps','ShowExpected','Rounding','main_position','preferences_position','OneByOne_position','OneByOne_PercentsCounts','MasterParser_position','FastaExtractor_position','FastaFixer_position','SeqViewerYES','GUspecialYES');

