%mFastaExtractor_multiple_forGUI.m     %By Ali Mokdad - 2006_01_23
%This program first reads a complete alignment file, then lets the user chose the positions that he needs
%to extract (motif) from that complete alignment to make a smaller more relevent alignment.
if ~isdeployed,clc,end

if ~strcmp(DomainNamesToExtract,'All')
    SeqLimits = DomainLimits(DomainsToExtract)+1+IgnoreTopOrganisms : DomainLimits(DomainsToExtract+1);
else
    SeqLimits = DomainLimits(1)+1+IgnoreTopOrganisms : DomainLimits(end);
end
n = 1; %needed for mGetUnivFromAnyFasta
mGetUnivFromAnyFasta

OrganismName=OrganismName{1};

for lpi=1:length(LocPosInput)
%     try
        MotifName=LocPosName{lpi};
        expd=LocPosInput{lpi};
        exp=regexprep(expd,'-',':');
        index   = findstr(',',exp);
        index=[0 index length(exp)+1];
        clear ex,    clear e, clear UNV %to prevent list mixups, when a previous motif is longer than the next
        for i=1:length(index)-1
            ex{i}=exp(index(i)+1:index(i+1)-1);
            e{i}=str2num(ex{i});
            if isempty(e{i})
                ex{i}=regexprep(ex{i},':',':-1:');
                e{i}=str2num(ex{i});
            end
        end
        for i=1:length(e)%same as length(index)-1
            UNV{i} = Univ(e{i});
            if length(UNV{i})>1
                if UNV{i}(1)<=UNV{i}(end)
                    UNV{i}=UNV{i}(1):UNV{i}(end); %This makes sure that continuous strands are given here, in case theire are jumps in universal numbers
                else
                    UNV{i}=UNV{i}(1):-1:UNV{i}(end); %same
                end
            end
        end

        FastaOutputFile{lpi} = strcat(FastaPath,FastaFilename,'_',DomainNamesToExtract,'__',OrganismName,'_',MotifName,'.fasta');
        FastafidOUT{lpi} = fopen(FastaOutputFile{lpi},'w+');
        if FastafidOUT{lpi} == -1      %Error check loop
            ErrorOUT = ['The file: ',FastaOutputFile{lpi},' could not be written to. It may be open. Please close it and try again'];
        else
            for j=SeqLimits
                fprintf(FastafidOUT{lpi},'%s%s%s%s%s%s\n','>',FastaOrganismNames{j},'__',OrganismName,'_',MotifName);
                for i=1:length(UNV) %same as length(index)-1 and length(e)
                    fprintf(FastafidOUT{lpi},'%s',Sequences(j,UNV{i}));
                    if i~=length(UNV)
                        fprintf(FastafidOUT{lpi},'%s','....');
                    end
                end
                fprintf(FastafidOUT{lpi},'\n');
            end
        end
        if FastafidOUT{lpi} ~= -1      %Error check loop
            fclose(FastafidOUT{lpi});
            fprintf('%s%s\n','Created ',FastaOutputFile{lpi});
        else
            fprintf('%s\n',ErrorOUT);
        end
        %     if ~isempty(BPlist)
        %         if length(InputData(1,:))==2 %This means a BP list
        %                 mBPlistExtractor %%%
        %             BPLOutputFile{lpi} = strcat(FastaPath,PositionList,'_',DomainNamesToExtract,'_',OrganismName,'_',expd,'.xls');
        %                 xlswrite(BPLOutputFile, BPsThatBelongHere);
        %             fprintf('%s%s\n\n','Created ',BPLOutputFile{lpi});
        %         end
        %     end
%     catch
%         if length(LocPosInput)>1, lpiSTR=num2str(lpi); else lpiSTR='';end
%         fprintf('%s%s\n%s\n','Format error in input ',lpiSTR,'Please follow this format: 2-12,16,30-17')
%     end
end
