function varargout = mFastaFixerGUI(varargin)
% MFASTAFIXERGUI M-file for mFastaFixerGUI.fig
%      MFASTAFIXERGUI, by itself, creates a new MFASTAFIXERGUI or raises the existing
%      singleton*.
%
%      H = MFASTAFIXERGUI returns the handle to a new MFASTAFIXERGUI or the handle to
%      the existing singleton*.
%
%      MFASTAFIXERGUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MFASTAFIXERGUI.M with the given input arguments.
%
%      MFASTAFIXERGUI('Property','Value',...) creates a new MFASTAFIXERGUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before mFastaFixerGUI_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to mFastaFixerGUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help mFastaFixerGUI

% Last Modified by GUIDE v2.5 11-Nov-2005 14:03:11

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @mFastaFixerGUI_OpeningFcn, ...
    'gui_OutputFcn',  @mFastaFixerGUI_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before mFastaFixerGUI is made visible.
function mFastaFixerGUI_OpeningFcn(hObject, eventdata, handles, varargin)

load('Preferences.mat');%This reads the last settings from the previous session
GUI_dimentions=get(hObject, 'position');%Used to extract the DIMENTIONS (the 3rd and 4th component) in case some changes to the GUI shape were made...
FastaFixer_position=[FastaFixer_position(1),FastaFixer_position(2),GUI_dimentions(3),GUI_dimentions(4)];
save('Preferences.mat','Audio','ShowTotals','ShowNs','ShowGaps','ShowExpected','Rounding','main_position','preferences_position','OneByOne_position','OneByOne_PercentsCounts','MasterParser_position','FastaExtractor_position','FastaFixer_position','SeqViewerYES','GUspecialYES');
set(hObject, 'position', FastaFixer_position);

% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to mFastaFixerGUI (see VARARGIN)

% Choose default command line output for mFastaFixerGUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes mFastaFixerGUI wait for user response (see UIRESUME)
% uiwait(handles.FigFastaFixer);


% --- Outputs from this function are returned to the command line.
function varargout = mFastaFixerGUI_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function edit1_Callback(hObject, eventdata, handles)
function edit1_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit2_Callback(hObject, eventdata, handles)
function edit2_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit3_Callback(hObject, eventdata, handles)
function edit3_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function pushbutton1_Callback(hObject, eventdata, handles)
if ispc
[FastaFilename, FastaPath] = uigetfile({'*.fasta','*.fasta';'*.*','*.*'},'Pick the 1st alignment file');
else
[FastaFilename, FastaPath] = uigetfile({'*.fasta','*.fasta';},'Pick the 1st alignment file');
end
file=strcat(FastaPath,FastaFilename);
set(handles.edit1,'String',file);

handles.FastaPath=FastaPath;
guidata(hObject,handles)

function pushbutton2_Callback(hObject, eventdata, handles)
if isfield(handles,'FastaPath')
if ispc
[FastaFilename, FastaPath] = uigetfile({'*.fasta','*.fasta';'*.*','*.*'},'Pick the 2nd alignment file',handles.FastaPath);
else
[FastaFilename, FastaPath] = uigetfile({'*.fasta','*.fasta';},'Pick the 2nd alignment file',handles.FastaPath);
end
file=strcat(FastaPath,FastaFilename);
set(handles.edit2,'String',file);
else
    fprintf('%s\n','Please browse for File 1 first');
end

function pushbutton3_Callback(hObject, eventdata, handles)
if isfield(handles,'FastaPath')
if ispc
    [FastaFilename, FastaPath] = uigetfile({'*.fasta','*.fasta';'*.*','*.*'},'Pick the 3rd alignment file',handles.FastaPath);
else
    [FastaFilename, FastaPath] = uigetfile({'*.fasta','*.fasta';},'Pick the 3rd alignment file',handles.FastaPath);
end
file=strcat(FastaPath,FastaFilename);
set(handles.edit3,'String',file);
else
    fprintf('%s\n','Please browse for File 1 and 2 first');
end


function RUN_Callback(hObject, eventdata, handles)
RUNAFTERmFastaFixerGUI=1;

%%%%%FILE1%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
file=get(handles.edit1,'String');
fprintf('\n%s\t\n','FILE 1');
ind= findstr('\',file);
if ~isempty(ind)
    FastaFilename  = file(ind(length(ind))+1:length(file));
    FastaPath   = file(1:ind(length(ind)));
else
    FastaFilename  = file;
    FastaPath   = strcat(cd,'\');
    file=strcat(FastaPath,FastaFilename);%file, if it doesn't include the path, is redefined here to include the current working directory as its path.
end

mMatchSeqLengths %This is the program that will add gaps to the ends of the file to make all Fasta sequences equal in length. The output will be of the same name +_GapsAdded
ind= findstr('.',FastaFilename);
PreFastaAlign = strcat(FastaFilename(1:ind-1),'_GapsAdded.fasta'); %FastaPath is created in mFastaFixerGUI or mGetFasta. It points to the original Fasta file to be fixed.
pathname = FastaPath;
FILE1_GapsAdded = strcat(pathname,PreFastaAlign);%This is the same as OutFilename, the output of mMatchSeqLengths
mFastaFixer %This program will remove repeated sequences and make a UNIQUE alignment file
FILE1_GapsAdded_UNIQUE = OUTfile;%This is the output of mFastaFixer
FILE1SeqCount   = SeqCount;%an output from mFastaFixer
FILE1KeptSeq    = KeptSeq; %an output from mFastaPrinter

%The following will be defined only here (after dealing with file), so the output files will be saved in the directory of the first file
MergedFile_GapsAdded        = strcat(FILE1_GapsAdded,'_MergedFile.fas');
MergedFile_GapsAdded_UNIQUE = strcat(FILE1_GapsAdded_UNIQUE,'_MergedFile.fas');

%%%%%FILE2%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~(strcmp(get(handles.edit2,'String'),'-')||isempty(get(handles.edit2,'String')))
    file=get(handles.edit2,'String');
    fprintf('\n%s\t\n','FILE 2');
    ind= findstr('\',file);
    if ~isempty(ind)
        FastaFilename  = file(ind(length(ind))+1:length(file));
        FastaPath   = file(1:ind(length(ind)));
    else
        FastaFilename  = file;
        FastaPath   = strcat(cd,'\');
        file=strcat(FastaPath,FastaFilename);%file, if it doesn't include the path, is redefined here to include the current working directory as its path.
    end
    mMatchSeqLengths %This is the program that will add gaps to the ends of the file to make all Fasta sequences equal in length. The output will be of the same name +_GapsAdded
    ind= findstr('.',FastaFilename);
    PreFastaAlign = strcat(FastaFilename(1:ind-1),'_GapsAdded.fasta'); %FastaPath is created in mFastaFixerGUI or mGetFasta. It points to the original Fasta file to be fixed.
    pathname = FastaPath;
    FILE2_GapsAdded = strcat(pathname,PreFastaAlign);%This is the same as OutFilename, the output of mMatchSeqLengths
    mFastaFixer %This program will remove repeated sequences and make a UNIQUE alignment file
    FILE2_GapsAdded_UNIQUE = OUTfile;%This is the output of mFastaFixer
    FILE2SeqCount   = SeqCount;%an output from mFastaFixer
    FILE2KeptSeq    = KeptSeq; %an output from mFastaPrinter


    if ~(strcmp(get(handles.edit3,'String'),'-')||isempty(get(handles.edit3,'String')))
        %%%%%FILE3%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        file=get(handles.edit3,'String');
        fprintf('\n%s\t\n','FILE 3');
        ind= findstr('\',file);
        if ~isempty(ind)
            FastaFilename  = file(ind(length(ind))+1:length(file));
            FastaPath   = file(1:ind(length(ind)));
        else
            FastaFilename  = file;
            FastaPath   = strcat(cd,'\');
            file=strcat(FastaPath,FastaFilename);%file, if it doesn't include the path, is redefined here to include the current working directory as its path.
        end
        mMatchSeqLengths %This is the program that will add gaps to the ends of the file to make all Fasta sequences equal in length. The output will be of the same name +_GapsAdded
        ind= findstr('.',FastaFilename);
        PreFastaAlign = strcat(FastaFilename(1:ind-1),'_GapsAdded.fasta'); %FastaPath is created in mFastaFixerGUI or mGetFasta. It points to the original Fasta file to be fixed.
        pathname = FastaPath;
        FILE3_GapsAdded = strcat(pathname,PreFastaAlign);%This is the same as OutFilename, the output of mMatchSeqLengths
        mFastaFixer %This program will remove repeated sequences and make a UNIQUE alignment file
        FILE3_GapsAdded_UNIQUE = OUTfile;%This is the output of mFastaFixer
        FILE3SeqCount   = SeqCount;%an output from mFastaFixer
        FILE3KeptSeq    = KeptSeq; %an output from mFastaPrinter


        %%%%%now create the merged files, only if at least file exists%%%
        fprintf('\n\n%s\n','Merging files:');
        eval( ['system(''copy/B "' FILE1_GapsAdded '" + "' FILE2_GapsAdded '" + "' FILE3_GapsAdded '" "' MergedFile_GapsAdded '"'');']);
        eval( ['system(''copy/B "' FILE1_GapsAdded_UNIQUE '" + "' FILE2_GapsAdded_UNIQUE '" + "' FILE3_GapsAdded_UNIQUE '" "' MergedFile_GapsAdded_UNIQUE '"'');']);
    else
        fprintf('\n\n%s\n','Merging files:');
        eval( ['system(''copy/B "' FILE1_GapsAdded '" + "' FILE2_GapsAdded '" "' MergedFile_GapsAdded '"'');']);
        eval( ['system(''copy/B "' FILE1_GapsAdded_UNIQUE '" + "' FILE2_GapsAdded_UNIQUE '" "' MergedFile_GapsAdded_UNIQUE '"'');']);
    end
end
%clc;

fprintf('\n\n\n%s\n','Please change the boundaries for the following files in mGetFasta:');
fprintf('\n');

fprintf('%s\n','Change the boundaries for the Original merged (Not UNIQUE) file into:');
fprintf('%s\t%g\t%s\n','ArchaeaEnd = ',FILE1SeqCount,';');
if ~(strcmp(get(handles.edit2,'String'),'-')||isempty(get(handles.edit2,'String')))
fprintf('%s\t%g\t%s\n','BacteriaEnd = ',FILE1SeqCount+FILE2SeqCount,';');
else fprintf('\n');
end
if ~(strcmp(get(handles.edit3,'String'),'-')||isempty(get(handles.edit3,'String')))
    fprintf('%s\t%g\t%s\n','EukaryaEnd = ',FILE1SeqCount+FILE2SeqCount+FILE3SeqCount,';');
else fprintf('\n');
end
fprintf('\n');

fprintf('%s\n','Change the boundaries for the UNIQUE file into:');
fprintf('%s\t%g\t%s\n','ArchaeaEnd = ',FILE1KeptSeq,';');
if ~(strcmp(get(handles.edit2,'String'),'-')||isempty(get(handles.edit2,'String')))
fprintf('%s\t%g\t%s\n','BacteriaEnd = ',FILE1KeptSeq+FILE2KeptSeq,';');
else fprintf('\n');
end
if ~(strcmp(get(handles.edit3,'String'),'-')||isempty(get(handles.edit3,'String')))
    fprintf('%s\t%g\t%s\n','EukaryaEnd = ',FILE1KeptSeq+FILE2KeptSeq+FILE3KeptSeq,';');
else fprintf('\n');
end
fprintf('\n');


fprintf('%s\n','Also, don''t forget to change the names of the resulting merged files and to run mGetFasta to save their information as .mat as well');
fprintf('\n');

clear RUNAFTERmFastaFixerGUI


% --- Executes during object deletion, before destroying properties.
function FigFastaFixer_DeleteFcn(hObject, eventdata, handles)
load('Preferences.mat');%This reads the last settings from the previous session
FastaFixer_position=get(hObject, 'position');  %Updated here just before closing, this way, the next time this GUI will open in the same location it was closed in
save('Preferences.mat','Audio','ShowTotals','ShowNs','ShowGaps','ShowExpected','Rounding','main_position','preferences_position','OneByOne_position','OneByOne_PercentsCounts','MasterParser_position','FastaExtractor_position','FastaFixer_position','SeqViewerYES','GUspecialYES');

