%mFastaNameRenamer.m
tic

clear
if ~isdeployed,clc,end

%First, load sequences for which you need to find matches for their FastaOrganismNames which are incomplete
load('5S_ABE_2004_UNIQUE.mat')
QueryPhyl = [0 ArchaeaEnd BacteriaEnd EukaryaEnd];
QueryName = FastaOrganismNames;

%Then, load other sequences from which you are looking for hits with the same FastaOrganismNames(s), hopefully more complete FastaOrganismNames(s)
load('16S_ABE_2004_UNIQUE.mat')
DataBaseName1 = FastaOrganismNames;
FastaName16S  = FastaOrganismNames;

load('23S_ABE_2004_UNIQUE.mat')
DataBaseName2 = FastaOrganismNames;

load('tRNA_alignment_results_NTs.xls_UNIQUE.mat')
DataBaseName3 = FastaOrganismNames;

% load('FastaName_5S_2004_Unique.mat')
% load('FastaName_tRNA_2004_Unique.mat')
% load('FastaName_23S_2004_Unique.mat')
% load('FastaName_16S_2004_Unique.mat')
%Phylogeny=1;    %Archaea
P=1;

%Order=[16S,23S,tRNA];
Beg = [0];   %This+1 is beginning of Archaea in 16S_2004
End = [220]; %9943 %This is ArchaeaEnd in 16S_2004

hitcount=0;
for i=1:40%length(QueryName)
    text=QueryName{i};
    IndQuery = findstr('_',text);
    
    if length(text)>=IndQuery+4
        text1=text(IndQuery+1:IndQuery+4);
    else text1=name(IndQuery+1:length(text));
    end
    if length(text)>=IndQuery+8
        text2=text(IndQuery+5:IndQuery+8);
    else text2=name(IndQuery+5:length(text));
    end
    fprintf('%g\t%s\t',i,text);
    %for i=1:length(FastaName16S),[S K(i)]=size(FastaName16S{i});end, add=max(K);
    hit=0;
    for j=Beg(P)+1:End(P)
        name=FastaName16S{j};
        Ind16SA = findstr('_',name);
        if length(Ind16SA)>1
            name1=name(Ind16SA(1)+1:Ind16SA(1)+4);
            if length(name)>=Ind16SA(2)+4,
                name2=name(Ind16SA(2)+1:Ind16SA(2)+4);
            else name2=name(Ind16SA(2)+1:length(name));
            end
        end
        if (strcmpi(text1,name1))&(strcmpi(text2,name2))
            hitcount=hitcount+1;
            fprintf('%s',name);
            add=40-length(name);
            if add>0
                eval(['fprintf(''%',num2str(add),'s\t'','''');']);
            else fprintf('\t');
            end
            hit=hit+1;
            if hit==1,jSaved=j;end
        end
    end
    fprintf('\n');
    if hit==1,QueryName{i}=FastaName16S{jSaved};end
end
fprintf('\n');

if ~isdeployed,clc,end;
for i=1:40
fprintf('%s\n',QueryName{i}); 
end
toc