%mFastaPrinter.m

Criteria=1;%Criteria for deciding how to pick the best sequence if repeats are met. 1 for TotACGU, and 2 for IntGaps
FL=50;%This is the length of each fasta line, and line break will be added after this much characters on wach line
KeptSeq=0;
ind = findstr('.',PreFastaAlign);
ind = ind(length(ind));%this sets up the ind to the last . if many are present
OUTfile = strcat(pathname,PreFastaAlign(1:ind-1),'_UNIQUE.fasta');
fprintf('%s %s %s %s %s\n','Started Fixing',PreFastaAlign,'and saving a new "UNIQUE" alignment into',OUTfile,'...')
fidOUT = fopen(OUTfile,'w+');

if fidOUT == -1      %Error check loop
    ErrorOUT = ['The file: ',OUTfile,' could not be written to. It may be opened. Please close it and try again']
    if Audio==1
        try
            [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'ohno']);
            sound(Ys,Fs); %wavplay(Ys,Fs,'async')
        end
    end
else

    %%%%%%%%%%%%%%%%%%%THE ACTUAL WORK STARTS HERE, FIRST: find repeated sequences%%%%%%%%%%%%%%%%%%%
    Seq=1;
    while Seq<=length(FastaOrganismNames)
        IND=strfind(FastaOrganismNames,FastaOrganismNames{Seq});

        index=[];
        for i=1:length(IND)
            if IND{i}==1
                index=[index i];
            end
        end
        %index
        
        %----------SECOND: chose the best repeated sequence according to IntGaps or TotACGU criteria------------
        if length(index)==1
            fprintf(fidOUT,'%s%s\n','>',FastaComment{index});
            
            %fprintf(fidOUT,'%s\n',Sequences(index,:)); 
            for j=1:FL:length(Sequences(index,:))
                if length(Sequences(index,:))>j+FL-1
                    fprintf(fidOUT,'%s\n',Sequences(index,j:j+FL-1));
                else
                    fprintf(fidOUT,'%s\n',Sequences(index,j:end));
                end
            end

        else %In case a sequence with the same FastaOrganismNames (first word of FastaComment) is repeated several times, then:
            if Criteria ==1     %Chose one sequence according to TotACGU (best)
                [TotACGUcount,indadd] = max(TotACGU(index));
            elseif Criteria ==2 %Chose one sequence according to IntGaps (also good, but may be different)
                [IntGapsCount,indadd] = min(IntGaps(index));
%             else %Just chose the first among the repeats (most random, worst)
%                 indadd = 1;
            end
            fprintf(fidOUT,'%s%s\n','>',FastaComment{index(1)+indadd-1});
            
            %fprintf(fidOUT,'%s\n',Sequences(index(1)+indadd-1,:));
            for j=1:FL:length(Sequences(index(1)+indadd-1,:))
                if length(Sequences(index(1)+indadd-1,:))>j+FL-1
                    fprintf(fidOUT,'%s\n',Sequences(index(1)+indadd-1,j:j+FL-1));
                else
                    fprintf(fidOUT,'%s\n',Sequences(index(1)+indadd-1,j:end));
                end
            end

        end
        %-----------------------------------
        
        KeptSeq = KeptSeq + 1;
        Seq = Seq + length(index);%this will speed it up since the Seq will jump over repeats with the same FastaOrganismNames
        if(Seq/100)==fix(Seq/100),fprintf('%g\n',Seq);end
    end


    fclose(fidOUT);
    fprintf('%g%s%s%s%s\n',SeqCount-KeptSeq,' sequences were dropped from the alignment ',PreFastaAlign,' and a UNIQUE alignment is saved to ',OUTfile);
    fprintf('%s%g%s%s\n','There are now ',KeptSeq,' Unique Sequences in ',OUTfile);
    
    if ~exist('Audio','var'),Audio=0;end
    if Audio==1
        try
            [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'longsuccess']);
            sound(Ys,Fs); %wavplay(Ys,Fs,'async')
        end
    end
end