%mPrintFastaFromMat.m   %prints a FASTA alignment file from a saved .mat file, sometimes useful to go back and forth from .mat to FASTA
% tic

%clear%<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
%function mPrintFastaFromMat(Audio)

FL=50;%This is the length of each fasta line, and line break will be added after this much characters on wach line

if ispc, sep='\'; else, sep='/';end

if ~exist('Audio','var'),Audio=0;end

if (~exist('FastaPath','var'))||(exist('FastaFilename','var')&&(~strcmp(class(FastaFilename),'char')))
    if exist(strcat('..',sep,'..',sep,'FASTA_alignments'),'dir')
        OrigDir=cd;
        ind= findstr(sep,OrigDir);
        FastaPath=strcat(OrigDir(1:ind(length(ind)-1)),'FASTA_alignments\');
    elseif exist(strcat('..',sep,'FASTA_alignments'),'dir')
        OrigDir=cd;
        ind= findstr(sep,OrigDir);
        FastaPath=strcat(OrigDir(1:ind(length(ind))),'FASTA_alignments\');
    else FastaPath=strcat(cd,sep);
    end
    %chdir ../FASTA_alignments/
elseif FastaPath==0
    FastaPath=strcat(cd,sep);;
end

[MatFile, MatPath] = uigetfile({'*.mat'},'Pick a saved alignment data file',FastaPath);


if strcmp(class(MatFile),'char') %In case browser prompt was cancelled
    load(strcat(MatPath,MatFile));
    ind= findstr('.',MatFile);
    MatFile = MatFile(1:ind(end)-1);

    for F=1:length(DomainNames)
        fprintf('%s%s%s\n','Printing ',DomainNames{F},' into a separate FASTA file ...');
        Output{F} = strcat(MatPath,MatFile,'_',DomainNames{F},'.fasta');
        fidOUT(F) = fopen(Output{F},'w+');
        if (fidOUT(F) ~= -1)
            for i= DomainLimits(F)+1:DomainLimits(F+1)
                if fix(i/100)==i/100,fprintf('%g\n',i),end
                fprintf(fidOUT(F),'%s%s\n','>',FastaOrganismNames{i});

                %fprintf(fidOUT(F),'%s\n',Sequences(i,:));
                for j=1:FL:length(Sequences(i,:))
                    if length(Sequences(i,:))>j+FL-1
                        fprintf(fidOUT(F),'%s\n',Sequences(i,j:j+FL-1));
                    else
                        fprintf(fidOUT(F),'%s\n',Sequences(i,j:end));
                    end
                end

            end
            fclose(fidOUT(F));
            Error(F)=0;
        else
            Error(F)=F;
        end
    end

    %Printing all in one file
    if length(DomainNames)>1
        F=F+1;
        fprintf('%s\n','Merging all the domains into one file ...');
        Output{F} = strcat(MatPath,MatFile,'_ALL.fasta');
        %         fidOUT(F) = fopen(Output{F},'w+');
        %         if (Output{F} ~= -1)
        %             for i = 1:DomainLimits(end)
        %                 if fix(i/100)==i/100,fprintf('%g\n',i),end
        %                 fprintf(fidOUT(F),'%s%s\n','>',FastaOrganismNames{i});
        %                 %fprintf(fidOUT(F),'%s\n',Sequences(i,:));
        %                 for j=1:FL:length(Sequences(i,:))
        %                     if length(Sequences(i,:))>j+FL-1
        %                         fprintf(fidOUT(F),'%s\n',Sequences(i,j:j+FL-1));
        %                     else
        %                         fprintf(fidOUT(F),'%s\n',Sequences(i,:));
        %                     end
        %                 end
        %
        %             end
        %             fclose(fidOUT(F));
        %             Error(F)=0;
        %         else
        %             Error(F)=F;
        %         end
%         try
            O=[];
            for i=1:length(DomainNames)
                O=strcat(O,'"',Output{i},'"+');
            end
            O=O(1:end-1);%to remove the last +
            eval( ['system(''copy/B ' O ' "' Output{F} '"'');'] ); %%%%MUCH FASTER THAN CODE ABOVE
            Error(F)=0;
%         catch
%             Error(F)=F;
%         end

    end
    % TotFiles=F;

    if Error==0 %This will be true only if ALL of them are 0
        fprintf('\n%g%s\n',F,' FASTA files were created and saved as:');
        for F=1:length(Output)
            fprintf('%s\n',Output{F});
        end
        if Audio == 1
            try
                [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'done2']);
                sound(Ys,Fs); %wavplay(Ys,Fs,'async')
            end
        end
    end

    %Error reporting:
    for F=1:length(Output)
        if Error(F)==F
            fprintf('%s%s%s\n','Error printing: the file ',Output{F},' is open, please close it and try again');
            if Audio == 1
                try
                    [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'ohno']);
                    sound(Ys,Fs); %wavplay(Ys,Fs,'async')
                end
            end
            break
        end
    end

else
    fprintf('%s\n','Loading .mat file cancelled by user');
    if Audio == 1
        try
            [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'cancel']);
            sound(Ys,Fs); %wavplay(Ys,Fs,'async')
        end
    end
end

% toc
