%mtRNAFastaWriterFromExcel.m    %Master for: mGetUnivFromAnyFasta
%Reads the tRNA raw alignment excel file (Compilation of tRNA Sequences) downloaded from the website
%http://www.uni-bayreuth.de/departments/biochemie/trna/
%Comiled and aligned by: Mathias Sprinzl, Konstantin S. Vassilenko
%Then makes an text Fasta alignment file that can be used by our programs (ex. mMutualCounterGUI)

tic
clear
clc;

Audio=1;
if ~exist('Audio'),Audio=0;end

%OriginalDir = cd;

[ExcelAlignFile, ExcelAlignPath] = uigetfile({'*.xls;'},'Pick the appropriate .xls alignment file');%,'MultiSelect', 'on');
fprintf('%s\n','Reading the alignment input file in its excel format, please wait ...');
InputFile = strcat(ExcelAlignPath,ExcelAlignFile);

%FastaFilename = ('../FASTA_alignments/Hairpin_closing_16S.xls');
[InputData, InputText] = xlsread(InputFile);
if Audio==1
    [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'done1']);
    sound(Ys,Fs); %wavplay(Ys,Fs,'async')
end
time=[num2str(toc/60) ' minutes have passed, and the input excel alignment file has been read']

%pdb filename at    InputText(n,1)
%aa at              InputText(n,2)
%Anticodon at       InputText(n,4)
%Organism name at   InputText(n,6)
%Domain at          InputText(n,16)
%Sequences starts at InputText(n,19), ends at length(InputText(2,:))

OUTfile = strcat(InputFile,'.fasta');
fidOUT = fopen(OUTfile,'w+');

if fidOUT == -1      %Error check loop
    ErrorOUT = ['The file: ',OUT,' could not be written to. It may be opened. Please close it and try again']
    if Audio==1
        [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'ohno']);
        sound(Ys,Fs); %wavplay(Ys,Fs,'async')
    end
else
    for n=2:2:length(InputText(:,1))%The sequences are at alternating lines starting from the second
        fprintf('%g\n',n/2);
        FastaComment(n)=strcat(regexprep(InputText(n,16),' ','-'),'_',regexprep(InputText(n,6),' ','_'),'_',InputText(n,1),'_',InputText(n,2),'_',InputText(n,4));
        fprintf(fidOUT,'%s%s\n','>',FastaComment{n});   %This prints the fasta comment line
        for i=19:length(InputText(2,:))                 %This prints the actual sequence
            if (n<=length(InputData(:,1)))&(i<=length(InputData(1,:))) %Sometimes the InputData is shorter than InputText. This if solves the ohno.
                if isnan(InputData(n,i))==0 %if there is a number inside the sequence data, then keep the number in the same place, it is actually equivalent to a gap '-'
                    string=num2str(InputData(n,i));
                    mtRNA_Replacements; %Subfunction
                    fprintf(fidOUT,'%s',string);
                else
                    string=InputText{n+1,i};
                    mtRNA_Replacements; %Subfunction
                    fprintf(fidOUT,'%s',string);
                end
            else
                string=InputText{n,i};
                mtRNA_Replacements; %Subfunction
                fprintf(fidOUT,'%s',string);
            end
        end
        fprintf(fidOUT,'\n');
    end
    fclose(fidOUT);
    if Audio==1
        try
            [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'longsuccess']);
            sound(Ys,Fs); %wavplay(Ys,Fs,'async')
        end
    end
end

time=[num2str(toc/60) ' minutes have passed, and Fasta file has been created']
