function [a,b] = GetabFromUniv(Count,M)
%Finds the most populated isoster

% if nargin==0
% Count= [3     4    10     6     0     0
%         2   400     6    86     0     0
%         8     1     5     2     0     0
%         3    72     4   388     0     0
%         0     0     0     0     0     0
%         0     0     0     0     0     0];
% M    = [2.1          0.9            2          1.1           14           13
%         1.2          3.1          1.1            3           14           13
%         002          1.1            0          0.9           14           13
%         1.1            3          1.2          3.1           14           13
%         014           14           14           14           14           13
%         013           13           13           13           13           13];
% end

[Ccond Mcond] = LinearizeAndCondense(Count,M);


%Find the one isoster with the highest count:
indcond                     =   find(Ccond==max(Ccond));
for i=1:length(indcond) %In case several isoster have the maximum count
    MostPopulatedIsoster    =   Mcond(indcond(i));
    if MostPopulatedIsoster > 0 && MostPopulatedIsoster < 13 %The first not forbidden and not gaps or N wins
        break
    end
end

%Find the 2D indices for that isoster with highest count:
ind2D = find2D(M,strcat('==',num2str(MostPopulatedIsoster)));

%Pick the one basepair (4x4 cell) with that isoster and with the highest individual count (not necessary, but looks better when indicated by bold)
MostPopulatedIsosterCounts = diag(Count(ind2D(:,1),ind2D(:,2)));
in = find(MostPopulatedIsosterCounts==max(MostPopulatedIsosterCounts));
a = ind2D(in(1),1);
b = ind2D(in(1),2);

