% zClassLimits stores the cutoffs for the computer classification of pairs
% according to displacement, normal vector, and angle of rotation.  As such,
% it is the repository of expert knowledge of pair classifications.

function [ClassLimits] = zClassLimits;

ClassLimits = zeros(50,12,16);

% For each paircode there is a matrix B which tells the upper and lower
% limits of various variables.
% The first column of B is the category, as in zListCategoryNames
% Some categories are further subdivided with decimal extensions.
% Columns 2 and 3 of B are upper and lower limits on displ(1).
% Columns 4 and 5 of B are upper and lower limits on displ(2).
% Columns 6 and 7 of B are upper and lower limits on displ(3).
% Columns 8 and 9 of B are upper and lower limits on normal(3).
% Columns 10 and 11 of B are limits on Ang (FlipAng or RotAng, depending on
% normal(3)).

% AA pairs (paircode 1) ------------------------------------------------------

B =    [  1    5.0  6.3  8.0 10.0 -3.0  3.0 -1.1 -0.7   70  105];  % cis WC-WC
B = [B;[  2    5.1  8.0  7.7  9.8 -3.0  3.0  0.58  1.1  155  195]]; % tr  WC-WC
%B = [B;[  3    5.2  7.2 -1.9 -0.9 -3.5  3.5  0.6  1.1   45   75]]; % cis WC-H?
B = [B;[  4    3.5  6.6  7.6  9.1 -3.0  3.0 -1.1 -0.7  145  190]]; % tr  H-WC
B = [B;[  5    4.0  5.5  6.4  8.5 -3.0  3.0 -1.1 -0.7   15   45]]; % cis WC-S
B = [B;[  6    2.3  3.3  8.1  9.1 -3.0  3.0  0.7  1.1  260  -70]]; % tr  S-WC
B = [B;[  8   -3.1 -0.9  6.4  8.5 -3.0  3.0  0.7  1.1  165  205]]; % tr  H-H 
B = [B;[  9   -4.4 -3.0  4.6  6.1 -3.0  3.0  0.7  1.1  -20   35]]; % cis H-S 
B = [B;[ 10   -1.5  0.6  7.1  8.9 -3.0  3.0 -1.1 -0.7   65  100]]; % tr  H-S
B = [B;[ 11    2.5  5.5 -6.6 -5.0 -3.0  3.1 -1.1 -0.6  260  -65]]; % cis S-S
B = [B;[ 12    6.1  8.2  1.1  4.1 -3.0  3.0  0.65  1.1  195  240]]; % tr  S-S
B = [B;[ 13    6.7  8.6  8.0  9.1 -3.0  3.0 -1.1 -0.7  120  155]]; % bifurc 
%B = [B;[ 21.1  0.0  5.0 -2.0  3.0  3.0  5.0  0.7  1.1   20   80]]; % above, up
B = [B;[ 21.2 -2.5 -1.4  2.5  4.0  3.0  3.8  0.8  1.1  195  -35]]; % above, up 
B = [B;[ 21.3  1.0  5.0 -1.5  3.0  3.0  4.2  0.4  1.1    0   50]]; % above, up
B = [B;[ 22.1  0.0  5.2   0.0  7.0  3.0  4.2 -1.1 -0.7   0  270]]; % above,down
%B = [B;[-21.1 -5.0 -1.0  0.0  4.0 -4.2 -2.9  0.7  1.1  -60  -20]]; % below, up
B = [B;[ 23.1  4.0  7.5  0.5  4.1 -4.2 -2.9 -1.1 -0.8   20   60]]; % below,down
B = [B;[ 23.2 -4.0  8.0 -4.0  8.0 -5.0 -2.0 -1.1 -0.7   90  155]]; % below,down

s = size(B);
ClassLimits(1:s(1),1:s(2),1) = B;                      % AA is paircode 1

% AC pairs (paircode 5) ------------------------------------------------------

B =    [  1    5.2  6.8  5.5  7.2 -3.0  3.0 -1.1 -0.7   54   95];  % cis WC-WC
B = [B;[  1.1  8.0  9.9  1.5  3.85 -3.0  3.0 -1.1 -0.7   25   78]]; % cis WC-WC
B = [B;[  1.2  6.4  7.6  4.3  6.6 -3.0  3.0 -1.1 -0.7   60   90]]; % cis WC-WC 
B = [B;[  2    3.3  4.3  8.2  9.2 -3.0  3.0  0.7  1.1  165  230]]; % tr  WC-WC
B = [B;[ -4   -2.8 -0.6  7.2  8.9 -3.0  3.0 -1.1 -0.8  140  175]]; % tr   H-WC
B = [B;[ -4.1 -4.0 -2.8  5.8  6.8 -3.0  3.0 -1.1 -0.8  150  180]]; % tr   H-WC
B = [B;[  5    3.0  6.1  6.5  9.0 -3.0  3.0 -1.1 -0.5   10   54]]; % cis WC-S
B = [B;[  5.1  1.6  2.6  7.3  9.3 -3.0  3.0 -1.1 -0.5   55   85]]; % cis WC-S
B = [B;[ -5    3.5  6.0 -6.1 -4.6 -3.0  3.0 -1.1 -0.6  -60   50]]; % cis S-WC
B = [B;[  6    1.7  3.3  7.8  9.0 -3.0  3.0  0.7  1.1  250  -50]]; % tr  WC-S
B = [B;[ -6    5.9  7.1 -5.6 -4.4 -3.0  3.0  0.7  1.1   20   70]]; % tr  WC-S
B = [B;[  8   -4.7 -2.6  6.4  7.9 -3.0  3.0  0.6  1.1  170  210]]; % tr   H-H
B = [B;[  9   -4.3 -3.1  4.8  5.9 -3.0  3.0  0.65  1.1  -48    0]]; % cis H-S
B = [B;[ -9    2.5  4.3 -6.0 -4.6 -3.0  3.0  0.8  1.1  -35    10]]; % cis S-H
B = [B;[ 10   -2.4  0.6  7.5  9.5 -3.0  3.0 -1.1 -0.8   60  125]]; % tr   H-S
B = [B;[-10    7.1  8.4 -4.0 -1.9 -3.0  3.0 -1.1 -0.8   50   92]]; % tr   S-H
B = [B;[ 11.0  2.3  4.7 -7.4 -5.8 -3.0  3.0 -1.1 -0.5  250  -70]]; % cis S-S
B = [B;[ 11.1  4.7  7.0 -7.4 -5.3 -3.0  3.0 -1.1 -0.7  235  -65]]; % with water
B = [B;[-11.1  5.7  7.7 -2.6 -0.0 -3.0  3.0 -1.1 -0.65 260  -40]]; % cis S-S
B = [B;[-11.2  3.9  5.8 -3.6 -2.1 -3.0  3.0 -1.1 -0.65 225  -80]]; % cis S-S
B = [B;[ 12    6.5  8.6  1.0  5.0 -3.0  3.0  0.55 1.1  200  260]]; % tr  S-S
B = [B;[ 13    8.0 10.0  5.6  6.8 -3.0  3.0 -1.1 -0.7   85  130]]; % ac bif
B = [B;[-13    1.0  2.2  8.3  9.4 -3.0  3.0 -1.1 -0.7   95  130]]; % ca bif
B = [B;[-13.1  3.1  4.7  8.0  9.3 -3.0  3.0 -1.1 -0.7   65  100]]; % ca bif
B = [B;[ 21.1  0.0  5.0 -1.0  3.0  3.0  4.2  0.4  1.1    5   80]]; % above, up
B = [B;[ 22.1  0.0  5.0 -4.0  8.0  3.0  4.2 -1.1 -0.4 -270  270]]; % above,down
B = [B;[-21.1 -5.0 -1.0 -1.0  4.0 -4.2 -2.9  0.7  1.1  -60  -20]]; % below, up
B = [B;[ 23.1  4.0  7.0  0.0  4.2 -4.2 -2.9 -1.1 -0.8   20   50]]; % below,down

s = size(B);
ClassLimits(1:s(1),1:s(2),5) = B;                      % AC is paircode 5

% CC pairs (paircode 6) ------------------------------------------------------

B =    [  1    6.3  7.2 -0.7  1.3 -2.9  2.9 -1.1 -0.7   30   65];  % cis WC-WC
B = [B;[  2    4.6  5.8  4.3  5.5 -3.0  3.0  0.7  1.1  160  190]]; % tr  WC-WC
B = [B;[  3    6.8  8.2  1.0  3.6 -3.0  3.0  0.7  1.1   60  100]]; % cis WC-H
B = [B;[  4    5.6  7.6  2.0  5.0 -3.0  3.0 -1.1 -0.7  115  165]]; % tr   H-WC
B = [B;[  5    3.6  5.8  5.2  6.8 -3.0  3.0 -1.1 -0.7  -40   35]]; % cis WC-S
B = [B;[  5.2  2.2  4.8  7.0  8.6 -3.0  3.0 -1.1 -0.7   70   80]]; % cis WC-S? 
B = [B;[  6    2.4  3.5  7.1  8.4 -3.0  3.0  0.5  1.1  240  -80]]; % tr   WC-S
B = [B;[  8   -4.7 -2.6  6.4  7.5 -3.0  3.0  0.6  1.1  170  210]]; % tr   H-H
B = [B;[  9   -6.0 -4.0  3.0  5.0 -3.0  3.0  0.7  1.1  -30   50]]; % cis H-S
B = [B;[ 10   -3.1 -1.1  6.5  8.5 -3.0  3.0 -1.1 -0.7   60  105]]; % tr   H-S
B = [B;[ 11    5.7  7.7 -6.0 -2.0 -3.0  3.0 -1.1 -0.7  230  -55]]; % cis S-S
B = [B;[ 13    7.5  8.8  1.2  3.2 -3.0  3.0 -1.1 -0.7   70   95]]; % cis WC-WC
B = [B;[ 13.1  6.9  7.9  4.3  5.4 -3.0  3.0 -1.1 -0.7   60   80]]; % ???
B = [B;[ 21.1  1.0  4.5 -1.0  2.0  3.0  4.6  0.7  1.1   20   50]]; % above, up
B = [B;[ 22.1  0.0  5.0 -4.0  8.0  3.0  4.2 -1.1 -0.4 -270  270]]; % above,down
B = [B;[-21.1 -5.0 -1.0  0.0  4.0 -4.2 -2.9  0.7  1.1  -60  -20]]; % below, up
B = [B;[ 23.1  4.0  7.0  0.0  4.0 -4.2 -2.9 -1.1 -0.8   20   50]]; % below,down

s = size(B);
ClassLimits(1:s(1),1:s(2),6) = B;                      % CC is paircode 6

% GC pairs (paircode 7) ------------------------------------------------------

B =    [  1    5.6  9.0  2.8  6.9 -3.0  3.0 -1.1 -0.7   45   90];  % cis WC-WC
B = [B;[  1.1  5.4  6.3  6.6  7.6 -3.0  3.0 -1.0  1.1   70  110]]; % tr  WC-WC
B = [B;[  2    6.4  7.7  4.2  6.1 -3.0  3.0  0.7  1.1  185  220]]; % tr  WC-WC
B = [B;[  3   -4.8 -2.1  4.5  8.0 -3.0  3.0  0.7  1.1  245  -50]]; % cis WC-H 
B = [B;[  4   -1.9 -0.7  7.6  8.8 -3.0  3.0 -1.1 -0.7  135  175]]; % tr  H-WC
B = [B;[  4.1 -0.4  2.6  9.1 11.9 -3.0  3.0 -1.1 -0.7  135  170]]; % tr  H-WC
B = [B;[  5    4.2  5.2 -6.3 -5.3 -3.0  3.0 -1.1 -0.6   30   60]]; % cis WC-S
B = [B;[ -5    6.5  7.6  4.0  5.4 -3.0  3.0 -1.1 -0.7   15   40]]; % cis S-WC
B = [B;[  6    6.8  7.7 -3.7 -2.6 -3.0  3.0  0.7  1.1   70  110]]; % tr  S-WC
B = [B;[ -6    4.7  6.2  5.9  7.3 -3.0  3.0  0.7  1.1  235  -80]]; % tr  S-WC
B = [B;[  7   -3.8 -2.6  4.7  5.9 -3.0  3.0 -1.1 -0.7  -40    0]]; % cis H-H
B = [B;[  8   -4.1 -3.1  6.7  7.8 -3.0  3.0  0.7  1.1  160  220]]; % tr   H-H
B = [B;[  8.1 -2.6 -1.6  8.1  9.1 -3.0  3.0  0.7  1.1  180  220]]; % tr   H-H
B = [B;[  9    2.0  3.3 -6.5 -5.3 -3.0  3.0  0.7  1.1  -40   10]]; % cis H-S
B = [B;[  9.1  4.0  5.2 -8.0 -5.9 -3.0  3.0  0.7  1.1    5   40]]; % cis H-S
B = [B;[ 11    6.1  7.6 -3.8 -2.2 -3.0  3.0 -1.1 -0.7  250  -60]]; % cis S-S
B = [B;[ 11.1  5.7  6.1 -4.0 -3.2 -3.0  3.0 -1.1 -0.7  -50  -20]]; % cis S-S
B = [B;[-11    2.6  3.9 -7.1 -5.6 -3.0  3.0 -1.1 -0.7  250  -70]]; % cis S-S
B = [B;[-12    7.8  9.0 -1.9 -0.5 -3.0  3.0  0.7  1.1  140  200]]; % tr  S-S

B = [B;[ 21.1  1.0  5.0 -1.0  2.5  3.0  4.4  0.5  1.1   20   60]]; % above, up
B = [B;[ 22.1 -2.0  2.0  1.0  5.0  2.7  4.1 -1.1 -0.5  200  -50]]; % above,down
B = [B;[ 22.1  1.0  5.0  1.0  6.0  2.5  4.2 -1.1 -0.5   50  160]]; % above,down
B = [B;[-21.1 -5.0  0.0 -0.5  3.2 -4.3 -2.2  0.7  1.1  -80  -15]]; % below, up
B = [B;[ 23.1  4.0  7.0  0.0  4.0 -4.2 -2.9 -1.1 -0.8   20   50]]; % below,down


s = size(B);
ClassLimits(1:s(1),1:s(2),7) = B;

% AG pairs (paircode 9) ------------------------------------------------------

B =    [  1    7.0  9.0  5.6  8.4 -3.5  3.5 -1.1 -0.65  65  100];  % cis WC-WC
B = [B;[  1.1  8.6  9.6  3.2  4.6 -3.0  3.0 -1.1 -0.7   50   75]]; % cis WC-WC
B = [B;[  1.2  5.8  7.0  7.6  8.6 -3.0  3.0 -1.1 -0.5   90  125]]; % cis WC-WC
B = [B;[  3    6.7  7.8  4.4  5.4 -3.0  3.0  0.7  1.1   70  100]]; % cis WC-H
B = [B;[  3.1  4.4  5.4  7.0  8.3 -3.0  3.04  0.7  1.1   75  110]]; % cis WC-H
B = [B;[ -3   -6.0 -4.9  6.5  7.8 -3.0  3.0  0.7  1.1  250  -80]]; % cis H-WC
B = [B;[  4    4.3  5.4  7.2  8.5 -3.0  3.02 -1.1 -0.7  155  185]]; % tr  H-WC
B = [B;[  5    3.7  4.7  6.9  8.7 -3.0  3.0 -1.1 -0.5   15   65]]; % cis WC-S
B = [B;[ -5    6.6  8.2 -5.4 -4.1 -3.0  3.0 -1.1 -0.5  -90   25]]; % cis S-WC
B = [B;[  6    1.5  3.3  8.0  9.4 -3.0  3.0  0.6  1.1  260  -50]]; % tr  WC-S
B = [B;[  6.1  6.3  7.8  6.4  8.5 -3.0  3.0  0.7  1.1  220  265]]; % tr  WC-S
B = [B;[  7   -4.6 -3.6  7.8  8.8 -3.0  3.0 -1.1 -0.7  180  225]]; % cis H-H
B = [B;[  8   -3.3 -1.5  8.5 10.2 -3.0  3.02  0.7  1.1  195  245]]; % tr  H-H
B = [B;[  9   -6.6 -5.6  2.5  3.6 -3.0  3.0  0.7  1.1   20   60]]; % cis H-S
B = [B;[ -9    4.9  6.1 -5.5 -4.3 -3.0  3.0  0.7  1.1  -10   30]]; % cis H-S
B = [B;[ 10   -2.0  0.7  7.1  9.0 -3.0  3.0 -1.1 -0.6   55  100]]; % tr  H-S
B = [B;[ 10.1 -3.3 -2.0  7.1  9.0 -3.0  3.0 -1.1 -0.6   55  100]]; % tr  H-S
B = [B;[ 10.2  0.2  1.7  9.0  9.7 -3.0  3.0 -1.1 -0.6   55  100]]; % tr  H-S
B = [B;[ 11    2.6  4.9 -6.6 -5.4 -3.0  3.0 -1.1 -0.5  260  -75]]; % cis S-S
B = [B;[-11    5.2  7.5 -2.5  0.5 -3.0  3.0 -1.1 -0.6  230  -50]]; % cis S-S
B = [B;[ 12    5.4  8.3 -0.6  3.5 -4.2  3.5  0.5  1.1  195  230]]; % tr  S-S
B = [B;[-12    7.4  8.7 -1.3 -0.1 -3.0  3.0  0.7  1.1  170  195]]; % tr  S-S
B = [B;[ 21.1  0.0  5.0 -1.0  3.0  3.0  4.8  0.4  1.1   20   70]]; % above, up
B = [B;[ 22.1  0.0  5.0 -2.0  4.0  3.0  4.2 -1.1 -0.4  -90  270]]; % above,down
B = [B;[-21.1 -5.0 -1.0  0.0  4.0 -4.2 -2.9  0.7  1.1  -80  -20]]; % below, up
B = [B;[ 23.1  4.0  7.0  0.0  4.0 -4.2 -2.9 -1.1 -0.8   20   50]]; % below,down

s = size(B);
ClassLimits(1:s(1),1:s(2),9) = B;                      % AG is paircode 9

% GG pairs (paircode 11) -----------------------------------------------------

B =    [  1    5.4  6.5  7.7  9.6 -3.6  3.6 -1.1 -0.5   70  105];  % cis WC-WC
B = [B;[  2    2.7  4.2  8.5 10.1 -3.0  3.0  0.7  1.1  180  230]]; % tr  WC-WC
B = [B;[  3    7.9  9.6  2.6  4.8 -3.0  3.0  0.7  1.1   70  110]]; % cis WC-H
B = [B;[  4    4.6  6.6  6.0  7.1 -3.0  3.0 -1.1 -0.7  155  200]]; % tr  H-WC
B = [B;[  5    6.9  8.1  5.9  7.1 -3.0  3.0 -1.1 -0.7   10   45]]; % cis WC-S
B = [B;[  7   -2.1 -0.9  5.5  6.7 -3.0  3.0 -1.1 -0.7  -45    0]]; % cis H-H
B = [B;[  8   -0.8  0.4  7.5  8.7 -3.0  3.0  0.7  1.1  100  140]]; % tr  H-H
B = [B;[  9   -6.1 -4.5  4.9  6.9 -3.0  3.0  0.7  1.1  -45    0]]; % cis H-S
B = [B;[ 10   -1.6  1.3  8.8 10.4 -3.0  3.0 -1.1 -0.7   70  105]]; % tr  H-S
B = [B;[ 10.1  1.3  2.0  9.1  9.9 -3.0  3.0 -1.1 -0.7   55   75]]; % tr  H-S
B = [B;[ 11    1.0  3.4 -6.9 -4.9 -3.0  3.0 -1.1 -0.7  230  265]]; % cis S-S
B = [B;[ 12    7.0  8.5 -3.0 -0.6 -3.0  3.0  0.7  1.1  160  195]]; % tr  S-S
B = [B;[ 13    6.6  8.0  7.3  8.6 -3.0  3.0 -1.1 -0.7  125  150]]; % bifurcated
B = [B;[ 21.1  0.0  4.6 -2.0  3.0  3.0  4.8  0.4  1.1    0   70]]; % above, up
B = [B;[ 22.1  0.0  7.0  0.0  6.0  2.0  4.2 -1.1 -0.4  -90  270]]; % above,down
B = [B;[-21.1 -5.0  0.2 -1.2  3.5 -4.8 -1.7  0.7  1.1  -72  -10]]; % below, up
B = [B;[ 23.1  4.0  7.5 -5.0  6.0 -5.0 -2.0 -1.1 -0.7    0   60]]; % below,down

s = size(B);
ClassLimits(1:s(1),1:s(2),11) = B;                      % GG is paircode 11

% AU pairs (paircode 13) ------------------------------------------------------

B =    [  1    5.6  8.5  3.2  6.8 -3.0  3.0 -1.1 -0.8   50   90];  % cis WC-WC
B = [B;[  2    4.8  6.4  6.0  7.8 -3.0  3.0  0.7  1.1  180  220]]; % tr   WC-WC
B = [B;[  3    6.0  8.0  4.2  6.2 -3.0  3.0  0.7  1.1   70  100]]; % cis WC-H
B = [B;[  3.1  8.0 10.0 -0.2  1.8 -3.0  3.0  0.7  1.1   60   90]]; % cis WC-H
B = [B;[ -3   -6.0 -4.0  3.0  5.5 -3.0  3.0  0.7  1.1  -85  -45]]; % cis H-WC
B = [B;[ -3.1 -6.5 -5.2  6.5  7.5 -3.0  3.0  0.7  1.1  -55  -40]]; % cis H-WC?
B = [B;[ -4   -5.0 -1.9  5.0  7.8 -3.0  3.0 -1.1 -0.7  140  190]]; % tr   H-WC
B = [B;[ -4.1 -2.1  0.0  7.7  9.5 -3.0  3.0 -1.1 -0.8   98  155]]; % tr   H-WC
B = [B;[  5    3.8  6.3  6.0  8.6 -3.0  3.0 -1.1 -0.6   10   60]]; % cis WC-S
B = [B;[ -5    3.8  5.2 -4.8 -3.3 -3.0  3.0 -1.1 -0.7  -55  -15]]; % cis S-WC
B = [B;[  6    2.0  3.2  7.8  9.0 -3.0  3.0  0.7  1.1  250  -50]]; % tr  WC-S
B = [B;[  6.1 -0.7  1.3  7.8  9.0 -3.0  3.0  0.65 1.1  -75  -45]]; % tr  WC-S
B = [B;[ -6    5.8  7.0 -3.2 -1.8 -3.0  3.0  0.7  1.1   90  120]]; % tr   S-WC
B = [B;[  8   -3.2 -1.0  8.3 10.5 -3.0  3.0  0.8  1.1  180  210]]; % tr   H-H
B = [B;[  8.1 -4.0 -3.0  5.5  6.5 -3.0  3.0  0.7  1.1  163  183]]; % tr   H-H
B = [B;[  8.2 -0.8  1.8  9.5 11.0 -3.0  3.0  0.8  1.1  180  220]]; % tr   H-H
B = [B;[  9   -3.2 -1.8  6.2  7.6 -3.0  3.0  0.6  1.1  -60  -35]]; % cis H-S
B = [B;[  9.1 -4.2 -3.5  4.5  5.8 -3.0  3.0  0.6  1.1   10   35]]; % cis H-S
B = [B;[ -9    6.6  8.0 -4.5 -3.5 -3.0  3.0  0.7  1.1   40   80]]; % cis H-S
B = [B;[ 10   -3.0  1.0  7.0  9.0 -3.0  3.0 -1.1 -0.8   60   98]]; % tr   H-S
B = [B;[ 10.1 -6.5 -3.8  1.0  4.0 -3.0  3.0 -1.1 -0.7  105  165]]; % tr   H-S
B = [B;[-10    9.3 11.0 -0.7  1.6 -3.0  3.0 -1.1 -0.7   60  115]]; % tr   H-S
B = [B;[ 11    3.8  5.3 -6.2 -3.4 -3.0  3.0 -1.1 -0.7  260  -55]]; % cis S-S
B = [B;[-11    5.7  7.3 -2.5  0.5 -3.5  3.9 -1.1 -0.6  260  -50]]; % cis S-S
B = [B;[ 12    7.0  8.7  0.9  3.7 -3.0  3.0  0.7  1.1  205  255]]; % tr  WC-S
B = [B;[ 21.1  0.0  5.0 -1.0  3.0  3.0  4.8  0.4  1.1   20   70]]; % above, up
B = [B;[ 22.1  0.0  5.0 -2.0  4.0  3.0  4.2 -1.1 -0.4  -90  270]]; % above,down
B = [B;[-21.1 -5.0 -1.0  0.0  4.0 -4.2 -2.9  0.7  1.1  -80  -20]]; % below, up
B = [B;[ 23.1  4.0  7.0  0.0  4.0 -4.2 -2.9 -1.1 -0.8   20   50]]; % below,down

s = size(B);
ClassLimits(1:s(1),1:s(2),13) = B;

% CU pairs (paircode 14) -----------------------------------------------------

B =    [  1    5.6  7.1  5.5  7.2 -3.0  3.0 -1.1 -0.7   85  105];  % cis WC-WC
B = [B;[  1.1  5.0  6.5  6.8  8.5 -3.0  3.0 -1.1 -0.7   100 115]]; % cis WC-WC
B = [B;[  1.2  5.7  6.8  2.3  4.0 -3.0  3.0 -1.1 -0.7   40   85]]; % cis WC-WC
B = [B;[  2    4.6  5.8  4.4  5.6 -3.0  3.0  0.7  1.1  160  200]]; % tr  WC-WC
B = [B;[  3    5.4  6.5  2.0  3.4 -3.0  3.0  0.7  1.1   45   85]]; % cis WC-H
B = [B;[  5    3.5  5.0  5.6  7.3 -3.0  3.0 -1.1 -0.7   30   70]]; % cis WC-S
B = [B;[ -5    5.2  6.4 -3.4 -2.2 -3.0  3.0 -1.1 -0.7  -45    0]]; % cis  S-WC
B = [B;[ -6    6.5  7.7 -1.9 -0.7 -3.0  3.0  0.7  1.1  105  145]]; % tr   S-WC
B = [B;[  8   -3.9 -1.9  7.7  9.5 -3.0  3.0  0.7  1.1  175  210]]; % tr   H-H
B = [B;[  9   -5.6 -3.9  3.4  6.2 -3.0  3.0  0.7  1.1  -40   40]]; % cis H-S
B = [B;[  9.1 -2.5 -0.7  7.5  8.7 -3.0  3.0  0.7  1.1  -80  -35]]; % cis H-S
B = [B;[ -9    3.2  5.3 -5.9 -4.5 -3.0  3.0  0.7  1.1  -40    5]]; % cis H-S
B = [B;[ 10   -3.4 -0.8  6.9  8.6 -3.0  3.0 -1.1 -0.7   65  120]]; % tr   H-S
B = [B;[ 11    2.4  4.2 -8.0 -6.0 -3.0  3.0 -1.1 -0.7  240  270]]; % cis S-S
B = [B;[-11    5.1  6.9 -3.7 -0.9 -3.3  3.3 -1.1 -0.7  -90  -30]]; % cis S-S
%B = [B;[ 21.1  0.0  5.0 -1.0  3.0  3.0  4.2  0.4  1.1   20   80]]; % above, up
%B = [B;[ 22.1  0.0  5.0 -4.0  8.0  3.0  4.2 -1.1 -0.4 -270  270]]; % above,down
%B = [B;[-21.1 -5.0 -1.0  0.0  4.0 -4.2 -2.9  0.7  1.1  -60  -20]]; % below, up
%B = [B;[ 23.1  4.0  7.0  0.0  4.0 -4.2 -2.9 -1.1 -0.8   20   50]]; % below,down

s = size(B);
ClassLimits(1:s(1),1:s(2),14) = B;                      % CU is paircode 14

% GU pairs (paircode 15) ------------------------------------------------------

B =    [  1    5.0  6.9  6.0  7.5 -3.0  3.0 -1.1 -0.7   50   90];  % cis WC-WC
B = [B;[  1.1  3.9  5.0  6.7  7.8 -3.0  3.0 -1.1 -0.7   50  100]]; % cis WC-WC
B = [B;[  1.2  5.5  7.5  4.7  6.0 -3.0  3.0 -1.1 -0.7   50   90]]; % cis WC-WC
B = [B;[  2    2.8  3.9  7.1  9.1 -3.4  3.0  0.7  1.1  180  215]]; % tr  WC-WC
B = [B;[ -3   -6.1 -5.1  2.7  3.4 -3.0  3.0  0.7  1.1  -65  -35]]; % cis H-WC
B = [B;[  4    5.1  7.9  6.5  8.2 -3.0  3.0 -1.1 -0.7  145  180]]; % tr  WC-H
B = [B;[ -4   -5.8 -4.8  5.1  6.1 -3.0  3.0 -1.1 -0.7  180  210]]; % tr  H-WC
B = [B;[  5    6.1  7.8  4.0  5.9 -3.0  3.0 -1.1 -0.7   15   40]]; % cis WC-S
B = [B;[  5.1  7.0  8.5  3.2  4.7 -3.0  3.0 -1.1 -0.7   40   55]]; % cis WC-S
B = [B;[  5.2  7.7  8.7  3.7  4.8 -3.0  3.0 -1.1 -0.7   65   95]]; % cis WC-S
B = [B;[ -5    2.8  3.8 -4.8 -3.8 -3.1  3.0 -1.1 -0.7  -65  -35]]; % cis S-WC
B = [B;[  6    4.9  7.5  5.1  7.6 -3.0  3.0  0.7  1.1  235  -80]]; % tr  WC-S
B = [B;[ -6    6.6  8.1 -3.7 -1.7 -3.0  3.0  0.7  1.1  115  155]]; % tr  S-WC
B = [B;[ -9    2.8  5.8 -6.2 -4.3 -3.0  3.0  0.7  1.1  -50    0]]; % cis H-S
B = [B;[ -9.1  8.0  9.2 -4.7 -3.7 -3.0  3.0  0.7  1.1  10    50]]; % cis H-S
B = [B;[ -9.2  5.6  6.4 -5.3 -4.3 -3.0  3.0  0.7  1.1  10    50]]; % cis H-S
B = [B;[-10    8.4 10.1 -3.7 -1.0 -3.0  3.0 -1.1 -0.7   60  100]]; % tr  S-H
B = [B;[ 11    1.6  4.1 -8.7 -5.9 -3.0  3.0 -1.1 -0.7  230  -70]]; % cis S-S
B = [B;[-11    5.7  7.5 -3.6 -1.9 -3.0  3.0 -1.1 -0.7  255  -50]]; % cis S-S
B = [B;[-11.1  4.3  5.2 -4.0 -3.0 -3.0  3.0 -1.1 -0.7  230  260]]; % cis S-S
B = [B;[ 12    8.1  8.9 -1.7  0.2 -3.0  3.0  0.7  1.1  180  220]]; % tr  S-S
B = [B;[ 13    7.5  9.2  5.6  7.5 -3.0  3.0 -1.1 -0.7  110  145]]; % bifurcated
B = [B;[ 25   -5.4 -3.7  1.6  3.3 -3.0  3.0 -1.1 -0.7  125  165]]; % motif

s = size(B);
ClassLimits(1:s(1),1:s(2),15) = B;

% UU pairs (paircode 16) -----------------------------------------------------

B =    [  1    3.4  5.7  4.1  6.8 -3.0  3.0 -1.1 -0.7   35   80];  % cis WC-WC
B = [B;[  2    3.0  4.2  6.9  8.1 -3.4  3.0  0.7  1.1  170  200]]; % tr  WC-WC
B = [B;[  3    6.6  7.6  0.8  2.4 -3.0  3.0  0.7  1.1   55   90]]; % cis WC-H
B = [B;[  4    3.8  5.3  6.2  7.1 -3.0  3.0 -1.1 -0.7  145  180]]; % tr  WC-H
B = [B;[  5    5.3  6.5  1.2  3.4 -3.0  3.0 -1.1 -0.7  -80  -30]]; % cis WC-S
B = [B;[  6    5.6  7.0  2.8  4.2 -3.0  3.0  0.7  1.1  200  230]]; % tr  WC-S
B = [B;[  9   -5.7 -4.5  4.1  5.3 -3.0  3.0  0.7  1.1    0   30]]; % cis H-S
B = [B;[ 11    4.7  5.9 -5.8 -4.6 -3.0  3.0 -1.1 -0.7  -90  -50]]; % cis S-S
B = [B;[ 21.1 -3.0  5.0 -1.0  3.0  3.0  4.2  0.4  1.1   20   80]]; % above, up
%B = [B;[ 22.1  0.0  5.0 -4.0  8.0  3.0  4.2 -1.1 -0.4 -270  270]]; % above,down
%B = [B;[-21.1 -5.0 -1.0  0.0  4.0 -4.2 -2.9  0.7  1.1  -60  -20]]; % below, up
%B = [B;[ 23.1  4.0  7.0  0.0  4.0 -4.2 -2.9 -1.1 -0.8   20   50]]; % below,down

s = size(B);
ClassLimits(1:s(1),1:s(2),16) = B;                      % UU is paircode 16
             
