function [void] = zPlotOneNT(NT,ViewParam)

X  = NT.Fit;

if isfield(ViewParam,'Sugar'),
  Sugar = ViewParam.Sugar;
else
  Sugar = 0;
end

if isfield(ViewParam,'LineStyle'),
  LS = ViewParam.LineStyle;
else
  LS = '-';
end

if isfield(ViewParam,'LineThickness'),   
  LT = ViewParam.LineThickness;
else
  LT = 2.0;                              % doesn't work for some reason!
end

if isfield(ViewParam,'LabelBases'),
  LB = ViewParam.LabelBases;
else
  LB = 0;
end

hold on 

switch NT.Code
case 1,
  col = [1 0 0];
  i = [13 1 7 12];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [7 10 8 5 6 15];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [6 14];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [5 4 9 11];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [9 3 2 8];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [2 1];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
case 2,
  col = [0 0 1];
  i = [9 1 7 10];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [7 8 11];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [8 5 6 12];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [13 6];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [5 4 2 3];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [2 1];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
case 3,
  col = [0 1 0];
  i = [14 1 7 13];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [7 10 8 5 6];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [5 4 12];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [4 9 11 16];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [11 15];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [9 3 2 8];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [2 1];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
case 4,
  col = [1 0.8 0];
  i = [10 1 7 12];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [7 8 9];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [8 5 6];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [5 4 11];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [4 2 3];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
  i = [2 1];
  plot3(X(i,1),X(i,2),X(i,3),'Color',col,'LineWidth',2,'LineStyle',LS);
end

scatter3(X(1,1),X(1,2),X(1,3),28,col,'filled');   % glycosidic atom

if Sugar == 1,

if length(NT.Sugar(:,1)) == 12,   % for some reason, some have 9
  Z = [NT.Sugar; NT.Fit(1,:)];

  k = [13 1 7 6 8 9 10 12]; 
  plot3(Z(k,1),Z(k,2),Z(k,3),'w','LineWidth',2,'LineStyle',LS);
  hold on
  k = [11 10]; 
  plot3(Z(k,1),Z(k,2),Z(k,3),'w','LineWidth',2,'LineStyle',LS);
  k = [6 4 5]; 
  plot3(Z(k,1),Z(k,2),Z(k,3),'w','LineWidth',2,'LineStyle',LS);
  k = [4 2 3]; 
  plot3(Z(k,1),Z(k,2),Z(k,3),'w','LineWidth',2,'LineStyle',LS);
  k = [2 1]; 
  plot3(Z(k,1),Z(k,2),Z(k,3),'w','LineWidth',2,'LineStyle',LS);
end

end

if LB == 1,
  text(X(1,1),X(1,2),X(1,3),[NT.Base NT.Number],'Color','w');
end
