% zSponer_Locations reads optimized bases by Sponer, centers and rotates them

% To graph the bases, run zPlotSponerBases

% Variables returned to the rest of the programs:
% 
% Sponer_Base      16 x 3 x 4 matrix of standard atom locations, all 4 bases
% Sponer_Names     16 x 4 cell array of names of atoms in Sponer bases
% Lim               2 x 4 matrix telling how many base atoms, total atoms
%                         (including hydrogen) the 4 bases have
%
% A_Stand, C_Stand, G_Stand, U_Stand: rotated versions of Sponer bases

% ------------------------------------------------------------------------
cd PDB_Analysis  %%ALI

[A_Atoms, zX, zY, zZ] = textread('Sponer_A','%s%10.6f%10.6f%10.6f');

Q = [zX zY zZ];
Q = Q - ones(length(zX),1)*Q(7,:);    % center base atoms at N9
v = Q(13,:) - Q(1,:);
c = v(2)/norm(v);
s = v(1)/norm(v);
Q = -Q * [[c s 0]; [-s c 0]; [0 0 1]]; % rotate 
A_Stand = Q;
clear zX zY zZ

% ------------------------------------------------------------------------
[C_Atoms, zX, zY, zZ] = textread('Sponer_C','%4s  %10.6f%10.6f%10.6f');

Q = [zX -zY zZ];
Q = Q - ones(length(zX),1)*Q(2,:);
v = Q(9,:) - Q(1,:);
c = v(2)/norm(v);
s = v(1)/norm(v);
Q = -Q * [[c s 0]; [-s c 0]; [0 0 1]];
C_Stand = Q;
clear zX zY zZ

% ------------------------------------------------------------------------
[G_Atoms, zX, zY, zZ] = textread('Sponer_G','%4s  %10.6f%10.6f%10.6f');

Q = [zX -zY zZ];
Q = Q - ones(length(zX),1)*Q(10,:);
v = Q(14,:) - Q(1,:);
c = v(2)/norm(v);
s = v(1)/norm(v);
Q = -Q * [[c s 0]; [-s c 0]; [0 0 1]];
G_Stand = Q;
clear zX zY zZ

% ------------------------------------------------------------------------
[U_Atoms, zX, zY, zZ] = textread('Sponer_U','%4s  %10.6f%10.6f%10.6f');

Q = [zX -zY zZ];
Q = Q - ones(length(zX),1)*Q(3,:);
v = Q(10,:) - Q(1,:);
c = v(2)/norm(v);
s = v(1)/norm(v);
Q = -Q * [[c s 0]; [-s c 0]; [0 0 1]];
U_Stand = Q;
clear zX zY zZ Q

%----------------------------------------------------------------------------
Sponer_Base = zeros(16,3,4);

% Center bases at glycosidic atom

Sponer_Base(1:15,:,1)= A_Stand-ones(size(A_Stand(:,1)))*A_Stand(1,:);
Sponer_Base(1:13,:,2)= C_Stand-ones(size(C_Stand(:,1)))*C_Stand(1,:);
Sponer_Base(1:16,:,3)= G_Stand-ones(size(G_Stand(:,1)))*G_Stand(1,:);
Sponer_Base(1:12,:,4)= U_Stand-ones(size(U_Stand(:,1)))*U_Stand(1,:);

Lim(1,:) = [10 8 11 8];       % number of base atoms, excluding hydrogen
Lim(2,:) = [15 13 16 12];     % total number of atoms, including hydrogen

Sponer_Names = cell(16,4);

Sponer_Names(1:Lim(2,1),1) = A_Atoms;   % provide a list of atom names
Sponer_Names(1:Lim(2,2),2) = C_Atoms;
Sponer_Names(1:Lim(2,3),3) = G_Atoms;
Sponer_Names(1:Lim(2,4),4) = U_Atoms;

%fprintf('Read bases A, C, G, U according to Sponer\n');

cd ..   %%ALI
