function varargout = Preferences(varargin)

gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Preferences_OpeningFcn, ...
                   'gui_OutputFcn',  @Preferences_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end


% --- Executes just before Preferences is made visible.
function Preferences_OpeningFcn(hObject, eventdata, handles, varargin)

load('Preferences.mat');%This reads the last settings from the previous session
GUI_dimentions=get(hObject, 'position');%Used to extract the DIMENTIONS (the 3rd and 4th component) in case some changes to the GUI shape were made...
preferences_position=[preferences_position(1),preferences_position(2),GUI_dimentions(3),GUI_dimentions(4)];
save('Preferences.mat','Pref','Audio','ShowTotals','ShowNs','ShowGaps','ShowExpected','Rounding','main_position','preferences_position','OneByOne_position','OneByOne_PercentsCounts','MasterParser_position','FastaExtractor_position','FastaFixer_position','SeqViewerYES','GUspecialYES');
set(hObject, 'position', preferences_position);

set(handles.SeqViewerYES,'Value',SeqViewerYES);
set(handles.GUspecialYES,'Value',GUspecialYES);

set(handles.AudioON,'Value',Audio);                 set(handles.AudioOFF,'Value',~Audio);
% set(handles.ShowPercentages,'Value',Percentages);   set(handles.ShowCounts,'Value',~Percentages);
set(handles.ShowTotalsYES,'Value',ShowTotals);      set(handles.ShowTotalsNO,'Value',~ShowTotals);
set(handles.ShowNsYES,'Value',ShowNs);              set(handles.ShowNsNO,'Value',~ShowNs);
set(handles.ShowGapsYES,'Value',ShowGaps);          set(handles.ShowGapsNO,'Value',~ShowGaps);
set(handles.ShowExpectedYES,'Value',ShowExpected);  set(handles.ShowExpectedNO,'Value',~ShowExpected);
set(handles.Rounding,'Value',Rounding+1);
% if strcmp(Delimiter,'\t')==1
%     set(handles.Lines,'Value',1); set(handles.Matrices,'Value',0);
% else set(handles.Lines,'Value',0); set(handles.Matrices,'Value',1);
% end

handles.output = hObject;
guidata(hObject, handles);
function varargout = Preferences_OutputFcn(hObject, eventdata, handles) 

varargout{1} = handles.output;


function Rounding_Callback(hObject, eventdata, handles)
function Rounding_CreateFcn(hObject, eventdata, handles)
if ispc,    set(hObject,'BackgroundColor','white');else,    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));end

function AudioON_Callback(hObject, eventdata, handles)
function AudioOFF_Callback(hObject, eventdata, handles)

% function ShowPercentages_Callback(hObject, eventdata, handles)
% function ShowCounts_Callback(hObject, eventdata, handles)

function ShowTotalsYES_Callback(hObject, eventdata, handles)
function ShowTotalsNO_Callback(hObject, eventdata, handles)

function ShowNsYES_Callback(hObject, eventdata, handles)
function ShowNsNO_Callback(hObject, eventdata, handles)

function ShowGapsYES_Callback(hObject, eventdata, handles)
function ShowGapsNO_Callback(hObject, eventdata, handles)

function ShowExpectedYES_Callback(hObject, eventdata, handles)
function ShowExpectedNO_Callback(hObject, eventdata, handles)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function RestoreDefaults_Callback(hObject, eventdata, handles)

Audio       =   1;
% Percentages =   1;
ShowTotals  =   1;
ShowNs      =   0;
ShowGaps    =   1;
ShowExpected=   0;
Rounding    =   0;
SeqViewerYES=   0;
GUspecialYES=   0;

set(handles.SeqViewerYES,'Value',SeqViewerYES);
set(handles.GUspecialYES,'Value',GUspecialYES);

set(handles.AudioON,'Value',Audio);
set(handles.AudioOFF,'Value',~Audio);

% set(handles.ShowPercentages,'Value',Percentages);
% set(handles.ShowCounts,'Value',~Percentages);

set(handles.ShowTotalsYES,'Value',ShowTotals);
set(handles.ShowTotalsNO,'Value',~ShowTotals);

set(handles.ShowNsYES,'Value',ShowNs);
set(handles.ShowNsNO,'Value',~ShowNs);

set(handles.ShowGapsYES,'Value',ShowGaps);
set(handles.ShowGapsNO,'Value',~ShowGaps);

set(handles.ShowExpectedYES,'Value',ShowExpected);
set(handles.ShowExpectedNO,'Value',~ShowExpected);

set(handles.Rounding,'Value',Rounding+1);

function SAVE_Callback(hObject, eventdata, handles)
load('Preferences.mat');%The values here will be overwritten by the values below. It is important to load this in order to resave 'main_position'&'preferences_position'

Audio       =   get(handles.AudioON,'Value');
% Percentages =   get(handles.ShowPercentages,'Value');
ShowTotals  =   get(handles.ShowTotalsYES,'Value');
ShowNs      =   get(handles.ShowNsYES,'Value');
ShowGaps    =   get(handles.ShowGapsYES,'Value');
ShowExpected=   get(handles.ShowExpectedYES,'Value');
Rounding    =   get(handles.Rounding,'Value')-1;
SeqViewerYES=   get(handles.SeqViewerYES,'Value');
GUspecialYES=   get(handles.GUspecialYES,'Value');


save('Preferences.mat','Pref','Audio','ShowTotals','ShowNs','ShowGaps','ShowExpected','Rounding','main_position','preferences_position','OneByOne_position','OneByOne_PercentsCounts','MasterParser_position','FastaExtractor_position','FastaFixer_position','SeqViewerYES','GUspecialYES');

close

function Cancel_Callback(hObject, eventdata, handles)
close


% --- Executes when FigPreferences is resized.
function FigPreferences_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to FigPreferences (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object deletion, before destroying properties.
function FigPreferences_DeleteFcn(hObject, eventdata, handles)
load('Preferences.mat');%This reads the last settings from the previous session
preferences_position=get(hObject, 'position');  %Updated here just before closing, this way, the next time this GUI will open in the same location it was closed in
save('Preferences.mat','Pref','Audio','ShowTotals','ShowNs','ShowGaps','ShowExpected','Rounding','main_position','preferences_position','OneByOne_position','OneByOne_PercentsCounts','MasterParser_position','FastaExtractor_position','FastaFixer_position','SeqViewerYES','GUspecialYES');


% --- Executes on button press in SeqViewerYES.
function SeqViewerYES_Callback(hObject, eventdata, handles)
function GUspecialYES_Callback(hObject, eventdata, handles)



% --- Executes on button press in ModifyScore.
function ModifyScore_Callback(hObject, eventdata, handles)
if ispc
    winopen('SCORES.txt')
else
    try
        open('SCORES.txt')
    catch
        fprintf('%s\n','The file <Ribostral/SCORES.txt> could not be opened automatically, please open it manually');
    end
end    

