function ind2D = find2D(A,condition)

%Example:
%A          = [.1,0,2; 2,1,0; 0,0,0; 2,2,0];
%condition  = '==0';
%condition  = '>0 & <=.2';

condition = regexprep(condition,'&&','&');
condition = regexprep(condition,'||','|');

andor = strfind(condition,'&');
if isempty(andor)
    andor = strfind(condition,'|');
end

if ~isempty(andor)
    ind = eval(['A',condition(1:andor-1), condition(andor) ,' A',condition(andor+1:end)]);
else
    ind = eval(['A',condition]);
end


L   = sum(sum(ind));

if L > 0
    c=0;
    ind2D=zeros(L,2);
    for i=1:length(ind(:,1))
        for j=1:length(ind(1,:))
            if ind(i,j)==1
                c=c+1;
                ind2D(c,1)=i;
                ind2D(c,2)=j;
            end
        end
    end
else
    ind2D=[];
end
