%mColorByIsostericity  By Ali Mokdad
function [htmlColor guiColor] = mColorByIsostericity(M)

F=0; U=15; G=13; N=14;
%Nearly-Isosteric groups must have difference in M <=0.2;
Y=0.9; O=1; R=1.1; P=1.2;   %Yellow, Orange, Red, and Pink (Yellow and Pink are not nearly isosteric, this complication is needed for Family 1, to make G/U not nearly isosteric to U/G, but both being nearly isosteric to regular WC) 
C=2; B=2.1;                 %Cyan and Blue
LG=3; DG=3.1;               %Light green and Dark green
brown=4;

if      M==Y,       htmlColor='FFFF00';      guiColor=[1 1 0];          %Yellow
elseif  M==O,       htmlColor='FF7F00';      guiColor=[1 .5 0];         %Orange
elseif  M==R,       htmlColor='FF0000';      guiColor=[1 0 0];          %Red
elseif  M==P,       htmlColor='FF0099';      guiColor=[1 0 .6];         %Red-Pink

elseif  M==C,       htmlColor='00CCFF';      guiColor=[0 .8 1];         %Cyan
elseif  M==B,       htmlColor='0033FF';      guiColor=[0 .2 1];         %Blue

elseif  M==LG,      htmlColor='00FF00';      guiColor=[0 1 0];          %Light Green
elseif  M==DG,      htmlColor='009900';      guiColor=[0 .6 0];         %Dark Green

elseif  M==brown,   htmlColor='996600';      guiColor=[.6 .4 0];        %BROWN

elseif  M==G,       htmlColor='CCCCCC';      guiColor=[.8 .8 .8];       %Light Gray    %%%%This indicates - or gap
elseif  M==N,       htmlColor='FFCC99';      guiColor=[1 .8 .6];        %Skin color    %%%%This indicates o or n
elseif  M==F,       htmlColor='666666';      guiColor=[.4 .4 .4];       %Dark Gray     %%%%This indicates a forbidden basepair
else                htmlColor='FFCC99';      guiColor=[1 .8 .6];        %Skin color    %%%%This indicates a baspair that is not given a structural designation
end

%AUther good color is Olive [.5 .5 0]
















