%mGetFasta.m

% try
warning off

%clear ChosenDomains
clear FastaOrganismNames
clear Sequences

warning off MATLAB:nonIntegerTruncatedInConversionToChar

M = mIsostericity;   %a program that defines the isosteric groups for each family (table) and clearly devides them into
%equal ones (isosteric), non-allowed ones (equal to the variable I0, which is by default zero), and gaps (equal to
% the variable n, which is set to 13 by default)

%Audio = '0'; Percentages = '0';Rounding = '2';

if ispc, sep='\'; else, sep='/';end

if ~exist('Audio','var'),Audio=0;end

if ~exist('RUNAFTERmFastaFixerGUI','var');%This may have been assigned before in another program, such as mFastaFixerGUI
    if ~isdeployed,clc,end
    %    OrigDir=cd;
    if (~exist('FastaPath','var'))||(exist('FastaFilename','var')&&(~strcmp(class(FastaFilename),'char')))
        if exist(strcat('..',sep,'FASTA_alignments'),'dir')
            OrigDir=cd;
            ind=findstr(sep,OrigDir);
            FastaPath=strcat(OrigDir(1:ind(length(ind))),'FASTA_alignments',sep);
        else FastaPath=strcat(cd,sep);
        end
        %chdir ../FASTA_alignments/
    elseif FastaPath==0
        FastaPath=strcat(cd,sep);
    end

    if ~exist('FastaPath','var') || ~exist('FastaFilename','var') %To allow script running without GUI
        if ispc
            if strcmp(Pref.FastaExtension,'mat')
                [FastaFilename, FastaPath] = uigetfile({...
                    '*.mat','*.mat (Saved alignment data, faster)';...
                    '*.fasta','*.fasta (Row alignment data, slower)';...
                    '*.*','*.* (all files)'},...
                    'Pick an alignment file',FastaPath);
            elseif strcmp(Pref.FastaExtension,'sta')
                [FastaFilename, FastaPath] = uigetfile({...
                    '*.fasta','*.fasta (Row alignment data, slower)';...
                    '*.mat','*.mat (Saved alignment data, faster)';...
                    '*.*','*.* (all files)'},...
                    'Pick an alignment file',FastaPath);
            else
                [FastaFilename, FastaPath] = uigetfile({...
                    '*.*','*.* (all files)';...
                    '*.mat','*.mat (Saved alignment data, faster)';...
                    '*.fasta','*.fasta (Row alignment data, slower)'},...
                    'Pick an alignment file',FastaPath);
            end
if strcmp(class(FastaFilename),'char')
	Pref.FastaExtension = FastaFilename(end-2:end); %Update Pref
	save('Preferences.mat','Pref','Audio','ShowTotals','ShowNs','ShowGaps','ShowExpected','Rounding','main_position','preferences_position','OneByOne_position','OneByOne_PercentsCounts','MasterParser_position','FastaExtractor_position','FastaFixer_position','SeqViewerYES','GUspecialYES');
end
        else
            [FastaFilename, FastaPath] = uigetfile({...
                '*.fasta','*.fasta'},...
                'Pick an alignment file',FastaPath);
        end
    end
end

if strcmp(class(FastaFilename),'char') %In case the prompt is cancelled
    if strmatch(FastaFilename(end-3:end),'.mat')
        load(strcat(FastaPath,FastaFilename));
    else
        [FastaOrganismNames, Sequences] = mfastaread(strcat(FastaPath,FastaFilename)); %mfastaread is based on fastaread from MATLAB Bioinformatics Toolbox, with some additions

        %%%%%The following code is to transform all N's and O's into o's, so that they are counted. Also all sequence letters are capitalized
        for s=1:length(Sequences(:,1))
            Sequences(s,:) = regexprep(upper(Sequences(s,:)), 'O|N', 'o');
        end
        %%%%%

        SeqLen = length(Sequences(:,1));
        [DomainNames DomainLimits] = mKnownFastaFilenamesChecker(FastaPath,FastaFilename,SeqLen);
        %mKnownFastaFilenamesChecker

        OriginalFastaFilename = FastaFilename;
        ind= findstr('.',FastaFilename);
        if isempty(ind)
            ind=length(FastaFilename)+1;
        end
        FastaFilename = strcat(FastaFilename(1:ind(end)-1),'.mat');
        savefile = strcat(FastaPath,FastaFilename);
        if ~exist('savefile','file')
            eval( ['save(''' savefile ''',''FastaFilename'',''FastaOrganismNames'',''DomainNames'',''DomainLimits'',''Sequences'');'])
            fprintf('%s%s\n','Data was saved in the file ',savefile);
        end
        FastaFilename = OriginalFastaFilename;
    end
    Pref.FastaPath = FastaPath; %Update Pref
    save('Preferences.mat','Pref','Audio','ShowTotals','ShowNs','ShowGaps','ShowExpected','Rounding','main_position','preferences_position','OneByOne_position','OneByOne_PercentsCounts','MasterParser_position','FastaExtractor_position','FastaFixer_position','SeqViewerYES','GUspecialYES');
    
    
    %SeqCount=length(Sequences(:,1));
    fprintf('%g%s%s%s\n',length(FastaOrganismNames),' FASTA Sequences from the file ',FastaFilename,' were loaded successfully')
    if Audio == 1
        try
            [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'done3']);
            sound(Ys,Fs); %sound(Ys,Fs); %wavplay(Ys,Fs,'async')
            %player=audioplayer(Ys,Fs);
            %play(player);
        end
    end
else
    fprintf('%s\n','Loading new alignment cancelled by user');
    if Audio == 1
        try
            [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'cancel']);
            sound(Ys,Fs); %wavplay(Ys,Fs,'async')
        end
    end
end
