%mGetPositions.m    %Master for: mGetUnivFromAnyFasta
%Should be run after reading a fasta alignment, via mGetFasta.m
%Reads an excel sheet that contains the local positions of nucleotides that you need to get the covariation for.
%Other programs (mainly mMutualCounter_IF) will then do the cvariation analysis on all these positions simultaneously.
% try

if (~exist('PositionPath','var'))||(exist('PositionList','var')&&(~strcmp(class(PositionList),'char')))
    if exist('../NT_lists','dir')
        OrigDir=cd;
        if ispc ==1 %ispc returns 1 if this is run on a PC (Windows)
            ind= findstr('\',OrigDir);  %Doesn't work on MAC
        else
            ind= findstr('/',OrigDir);  %Works on MAC
        end
        PositionPath=strcat(OrigDir(1:ind(length(ind))),'NT_lists\');
    else PositionPath=cd;
    end
    %chdir ../FASTA_alignments/
elseif PositionPath==0
    PositionPath=cd;
end
% OrigDir = cd;
% if exist('../NT_lists','dir'),cd('../NT_lists/'),end    %chdir ../FASTA_alignments/
if ~exist('PositionPath','var') || ~exist('PositionList','var') %To allow script running without GUI
    [PositionList, PositionPath] = uigetfile({'*.xls;'},'Pick a list of positions to study',PositionPath);%,'MultiSelect', 'on');
end
% cd(OrigDir)


if strcmp(class(PositionList),'char') %In case the prompt is cancelled

    InputFile = strcat(PositionPath,PositionList);

    %FastaFilename = ('../FASTA_alignments/Hairpin_closing_16S.xls');
    [InputData, InputText] = xlsread(InputFile);
if ~ispc %MAC reads the header line and put NaN in InputData, PC doesn't
    InputData = InputData(2:end,:);
end
Pref.PositionPath = PositionPath; %Update Pref
save('Preferences.mat','Pref','Audio','ShowTotals','ShowNs','ShowGaps','ShowExpected','Rounding','main_position','preferences_position','OneByOne_position','OneByOne_PercentsCounts','MasterParser_position','FastaExtractor_position','FastaFixer_position','SeqViewerYES','GUspecialYES');


if isempty(InputData),
    PositionList=0;
    fprintf('This is not a good Positions file\n')
    if Audio == 1
        try
        [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'ohno']);
        sound(Ys,Fs); %wavplay(Ys,Fs,'async')
        end
    end
    return
end

    OrganismName(1,length(InputData(:,1)))    =   {''};                             %Optimized for Speed%
    UnivBas         =   zeros(length(InputData(:,1)),length(InputData(1,:)));       %Optimized for Speed%
    Table           =   zeros(1,length(InputData(:,1)));                            %Optimized for Speed%

    PercentDoneLast=-1;
    FirstTime=0;
    for n=1:length(InputData(:,1))
        
        OrganismName{n} = InputText{n+1,1};
        if n == 1  %For the first iteration, when the organism name is read once and Universal numbers are calculated
            mGetUnivFromAnyFasta
        elseif strcmpi(OrganismName{n},OrganismName{n-1})==0   %only if they are different, then recalculate Universal numbers
            %fprintf('%g\t%s\t%s\n',n,OrganismName{n},OrganismName{n-1});
            %OrgInd
            mGetUnivFromAnyFasta    %Program that gets Universal numbers from Hm or Dd or Ec or any other organism
        else OrgInd(n)=OrgInd(n-1);
            FoundOrganism(n)=1;
        end

        if length(InputData(:,1))>99
            PercentDone = round(n*100/length(InputData(:,1)));
            if PercentDone ~= PercentDoneLast, %Only print percent counter in case it changes, to save time
                PercentDoneLast = PercentDone;
                if FirstTime==0,FirstTime=1; fprintf('\n\n\n\n\n'); end
                fprintf('\b\b\b\b\b%3g%s',   PercentDone,' %');
                %if PercentDone<11,  fprintf('\b\b\b%g%s',   PercentDone,' %');
                %else,               fprintf('\b\b\b\b%g%s', PercentDone,' %'); end
            end
        end
        %if n/100 == fix(n/100),    fprintf('%g\n',n); end
        
        
        % if  FoundOrganism(n)==1;
        SizeInputText = size(InputText);
        SizeInputData = size(InputData);

        if SizeInputData(2) == 2 %This is done only in the case of a base-PAIR list
            if SizeInputText(2) > SizeInputData(2) + 1 %this may mean that there is structural data (but maybe not at every row)
                if length(InputText{n+1,4})>0 %this means there is something written as a basepair family on this row
                    [Table(n),Interaction(n),InputData(n,1),InputData(n,2)]=mGetTableNumberFromName(InputText{n+1,4},InputData(n,1),InputData(n,2));
                else Table(n)=14;
                    Interaction(n) = {'-'};
                end
            else Table(n)=14;
                Interaction(n) = {'-'};
            end
        else Table(n)=14; Interaction(n)={'-'};
        end
        for b=1:length(InputData(1,:))
            if isnan(InputData(n,b)),InputData(n,b)=1;end  %Sometimes the input XLS queries are of different lengths, the short ones will be appended with 1's to prevent error and keep everything fast
            if InputData(n,b)==0,InputData(n,b)=1;end  %The zeroes will be made into 1 because there is no position zero in sequences!
            

            if InputData(n,b) <= length(Univ)
                UnivBas(n,b)=Univ(InputData(n,b));
            else
                fprintf('%s%g%s%g%s\n','NT List error: numbers requested (first error at ',InputData(n,b),') are beyond alignment size (',length(Univ),')');
                if Audio == 1
                    try
                    [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'ohno']);
                    sound(Ys,Fs); %wavplay(Ys,Fs,'async')
                    end
                end
                FoundOrganism(n)=0;
                return
            end
            
        end

        PosArray(:,:,n) = Sequences(:,UnivBas(n,:));                                %Optimized for Speed%
        % end
    end
    if length(InputData(:,1))>99
        fprintf('\n')
    end
    
    if FoundOrganism(n)==0 %In case one or more organism name from NT list is not found in the fasta file, this will stop
        fprintf('%s\n','Please make sure your NT list file corresponds to your fasta alignment file, and that organism names in the NT list file are spelled exactly as in the fasta file.');
        if Audio == 1
            try
            [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'ohno']);
            sound(Ys,Fs); %wavplay(Ys,Fs,'async')
            end
        end
    else
        if Audio == 1
            try
            [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'done4']);
            sound(Ys,Fs); %wavplay(Ys,Fs,'async')
            end
        end
    end
else
    fprintf('%s\n','Loading NT list cancelled by user');
    if Audio == 1
        try
        [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'cancel']);
        sound(Ys,Fs); %wavplay(Ys,Fs,'async')
        end
    end
end
