function Score = mGetScore(Mcond, Ccond, IsosterCompar, w)
%Here, gaps on one or both sides are treated equally, and weighed the average of wg1 and wg2.

% if nargin == 0
%     Mcond = [0  , 0.9, 1.1, 1.2, 2  , 2.1, 3   , 3.1 , 13, 14];
%     Ccond = [0.5, 0.6, 1.6, 0.6, 1.8, 0.3, 15.8, 78.8, 0 , 0 ];
%     IsosterCompar = 3.1;
%     w.wi=2; w.wni=1; w.wh=-1; w.wf=-5; w.wg1=-2; w.wg2=-3;
% end

indF    = find(Mcond==0);
F       = max([Ccond(indF), 0]);    %use this so you do not need to test if indF isempty

indG    = find(Mcond==13);          %This is any gap (one or both sides)
G       = Ccond(indG);              

indN    = find(Mcond==14);          %These are undetermined nucleotides (not needed for the Score, but needed to be removed from Mrem not to be counted as Heterosteric)
ind15   = find(Mcond==15);          %This is in case no isosteric family is specified


indI    = find(Mcond==IsosterCompar);
I       = Ccond(indI);              %always must be there, so no need to do    max([Ccond(indI), 0]);



if isempty(indF), indF = -1;  end %In case any of these is empty, -1 doesn't hurt because M has no such value
if isempty(indI), indI = -1;  end
if isempty(indG), indG = -1;  end
if isempty(indN), indN = -1;  end
if isempty(ind15),ind15= -1;  end


l=length(Mcond);
indRem  = find(   (1:l~=indF & 1:l~=indI & 1:l~=indG & 1:l~=indN & 1:l~=ind15)   ==1);
Mrem    = Mcond(indRem);
Crem    = Ccond(indRem);

dif     = abs(Mrem - IsosterCompar);


indNI   = find(dif < .25);           %Not isosteric are within .2, so take anything < .25 not to fall into infinitesimal errors
NI      = max([Crem(indNI), 0]);

indH    = find(dif > .25);           %Closest heterosteric is within .3, so take anything > .25 ....
H       = max([Crem(indH), 0]);

Score = (   I*w.wi + NI*w.wni + H*w.wh + F*w.wf + G*(w.wg1+w.wg2)*.5    )/w.wi;

