%mGetUnivFromAnyFasta.m
% Univ=zeros(1,length(Sequences(1,:)));

if regexpi(OrganismName{n},'univ')    %strcmpi gives exact case insensitive match %This is in case a Universal number is given as an input in the Positions list
    for U = 1:length(Sequences(1,:)), %length of all Sequences's is ususally the same
        Univ(U)=U;
    end
    fprintf('%s\n','Universal Numbers used for this position');
    OrgInd(n) = 1; %Assigned to the first sequence in the alignment file, meaningless really
    FoundOrganism(n)=1;

else        %This will get the Universal numbers from Local numbers of the specified organism in the input Positions list
    for s = 1:length(FastaOrganismNames) %this loop looks for the particular organism from which you want to give Local numbers
        if strfind(lower(FastaOrganismNames{s}),lower(OrganismName{n}))
            OrgInd(n) = s;
            FoundOrganism(n)=1;%This is just an indicator that the Organism whose name appears in the excel input list was found among the fasta files read.
            break %This will break this loop at the first hit of the organism name.
        else FoundOrganism(n)=0;
        end
    end

    if FoundOrganism(n)==0
        fprintf('%s %s %s\n','Error: the organism',OrganismName{n},'could not be found among the loaded alignment sequences');
        break %This will break the outer loop (for n) started in mGetPositions
    else
        L = 0;
        clear Local; clear Univ;
        for U = 1:length(Sequences(OrgInd(n),:)), %usually, length(Sequences(OrgInd(n),:)) is the same as length(Sequences(1,:) used above in case of a Universal Number input
            if (Sequences(OrgInd(n),U) ~= '-') && (Sequences(OrgInd(n),U) ~= ' ') %%This last condition prevents counting empty gaps
                L = L + 1;
                Local(U) = L;   %Save local numbers in an array to be accessed later if needed
                Univ(L) = U;    %Save Universal numbers in an array as well (This is more important)
            end
        end
        %From now on, every time a Universal Number of a particular Local Number n is needed, type Univ(n)
        %Also, if a Local Number of a certain universal position n is needed, type Local(n)
        fprintf('%s%s\n',FastaOrganismNames{OrgInd(n)},' was found, and Universal numbers successfully calculated from it');
    end
end