%mIsostericity.m by Ali Mokdad %This program is called from mGetFasta.m
function M = mIsostericity

F=0; U=15; G=13; N=14;
%Nearly-Isosteric groups must have difference in M <=0.2;
Y=0.9; O=1; R=1.1; P=1.2;   %Yellow, Orange, Red, and Pink (Yellow and Pink are not nearly isosteric, this complication is needed for Family 1, to make G/U not nearly isosteric to U/G, but both being nearly isosteric to regular WC) 
C=2; B=2.1;                 %Cyan and Blue
LG=3; DG=3.1;               %Light green and Dark green
brown=4;

%F denotes the FORBIDDEN basepairs
M(6,6,14)=0; %Initialization
M(:,5,:)=N;  %This is the column for o or n
M(5,:,:)=N;  %This is the row for o or n
M(:,6,:)=G;  %This is the column for - or gap
M(6,:,:)=G;  %This is the row for - or gap

%Table 14 (if a basepair name does not match any from our standard basepair name list)
M(1,1,14)=U;	M(1,2,14)=U;	M(1,3,14)=U;	M(1,4,14)=U;
M(2,1,14)=U;    M(2,2,14)=U;    M(2,3,14)=U;    M(2,4,14)=U;
M(3,1,14)=U;    M(3,2,14)=U;    M(3,3,14)=U;    M(3,4,14)=U;
M(4,1,14)=U;    M(4,2,14)=U;    M(4,3,14)=U;    M(4,4,14)=U;

%Table 1 (cWW):
M(1,1,1)=B;     M(1,2,1)=Y;     M(1,3,1)=C;     M(1,4,1)=R;
M(2,1,1)=P;     M(2,2,1)=DG;    M(2,3,1)=R;     M(2,4,1)=LG;
M(3,1,1)=C;     M(3,2,1)=R;     M(3,3,1)=F;     M(3,4,1)=Y;
M(4,1,1)=R;     M(4,2,1)=LG;    M(4,3,1)=P;     M(4,4,1)=DG;

%Table 2 (tWW):
M(1,1,2)=brown; M(1,2,2)=LG;    M(1,3,2)=F;     M(1,4,2)=Y;
M(2,1,2)=LG;    M(2,2,2)=B;     M(2,3,2)=R;     M(2,4,2)=C;
M(3,1,2)=F;     M(3,2,2)=R;     M(3,3,2)=brown; M(3,4,2)=LG;
M(4,1,2)=Y;     M(4,2,2)=C;     M(4,3,2)=LG;    M(4,4,2)=B;

%Table 3 (cWH):
M(1,1,3)=F;     M(1,2,3)=F;     M(1,3,3)=C;     M(1,4,3)=C;
M(2,1,3)=F;     M(2,2,3)=Y;     M(2,3,3)=R;     M(2,4,3)=R;
M(3,1,3)=C;     M(3,2,3)=F;     M(3,3,3)=B;     M(3,4,3)=F;
M(4,1,3)=R;     M(4,2,3)=F;     M(4,3,3)=R;     M(4,4,3)=Y;

%Table 4 (tWH):
M(1,1,4)=C;     M(1,2,4)=F;     M(1,3,4)=C;     M(1,4,4)=F;
M(2,1,4)=R;     M(2,2,4)=Y;     M(2,3,4)=R;     M(2,4,4)=F;
M(3,1,4)=F;     M(3,2,4)=F;     M(3,3,4)=B;     M(3,4,4)=C;
M(4,1,4)=Y;     M(4,2,4)=F;     M(4,3,4)=LG;    M(4,4,4)=R;

%Table 5 (cWS):
M(1,1,5)=R;     M(1,2,5)=R;     M(1,3,5)=R;     M(1,4,5)=R;
M(2,1,5)=C;     M(2,2,5)=C;     M(2,3,5)=C;     M(2,4,5)=C;
M(3,1,5)=Y;     M(3,2,5)=Y;     M(3,3,5)=O;     M(3,4,5)=Y;
M(4,1,5)=B;     M(4,2,5)=B;     M(4,3,5)=B;     M(4,4,5)=B;

%Table 6 (tWS):
M(1,1,6)=Y;     M(1,2,6)=Y;     M(1,3,6)=Y;     M(1,4,6)=Y;
M(2,1,6)=Y;     M(2,2,6)=Y;     M(2,3,6)=Y;     M(2,4,6)=Y;
M(3,1,6)=F;     M(3,2,6)=LG;    M(3,3,6)=F;     M(3,4,6)=LG;
M(4,1,6)=C;     M(4,2,6)=C;     M(4,3,6)=B;     M(4,4,6)=C;

%Table 7 (cHH):
M(1,1,7)=F;     M(1,2,7)=F;     M(1,3,7)=LG;    M(1,4,7)=F;
M(2,1,7)=F;     M(2,2,7)=F;     M(2,3,7)=Y;     M(2,4,7)=F;
M(3,1,7)=LG;    M(3,2,7)=Y;     M(3,3,7)=Y;     M(3,4,7)=F;
M(4,1,7)=F;     M(4,2,7)=F;     M(4,3,7)=F;     M(4,4,7)=F;

%Table 8 (tHH):
M(1,1,8)=Y;     M(1,2,8)=Y;     M(1,3,8)=R;     M(1,4,8)=R;
M(2,1,8)=Y;     M(2,2,8)=F;     M(2,3,8)=Y;     M(2,4,8)=R;
M(3,1,8)=R;     M(3,2,8)=Y;     M(3,3,8)=LG;    M(3,4,8)=F;
M(4,1,8)=R;     M(4,2,8)=R;     M(4,3,8)=F;     M(4,4,8)=F;

%Table 9 (cHS):
M(1,1,9)=R;     M(1,2,9)=Y;     M(1,3,9)=Y;     M(1,4,9)=Y;
M(2,1,9)=Y;     M(2,2,9)=R;     M(2,3,9)=Y;     M(2,4,9)=R;
M(3,1,9)=Y;     M(3,2,9)=F;     M(3,3,9)=Y;     M(3,4,9)=F;
M(4,1,9)=R;     M(4,2,9)=Y;     M(4,3,9)=R;     M(4,4,9)=Y;

%Table 10 (tHS):
M(1,1,10)=Y;    M(1,2,10)=Y;    M(1,3,10)=Y;    M(1,4,10)=Y;
M(2,1,10)=Y;    M(2,2,10)=Y;    M(2,3,10)=F;    M(2,4,10)=Y;
M(3,1,10)=F;    M(3,2,10)=F;    M(3,3,10)=LG;   M(3,4,10)=F;
M(4,1,10)=LG;   M(4,2,10)=F;    M(4,3,10)=LG;   M(4,4,10)=F;

%Table 11 (cSS):
M(1,1,11)=Y;    M(1,2,11)=Y;    M(1,3,11)=Y;    M(1,4,11)=Y;
M(2,1,11)=Y;    M(2,2,11)=Y;    M(2,3,11)=Y;    M(2,4,11)=Y;
M(3,1,11)=Y;    M(3,2,11)=Y;    M(3,3,11)=Y;    M(3,4,11)=Y;
M(4,1,11)=Y;    M(4,2,11)=Y;    M(4,3,11)=Y;    M(4,4,11)=Y;

%Table 12 (tSs):
M(1,1,12)=Y;    M(1,2,12)=Y;    M(1,3,12)=Y;    M(1,4,12)=Y;
M(2,1,12)=F;    M(2,2,12)=F;    M(2,3,12)=F;    M(2,4,12)=F;
M(3,1,12)=R;    M(3,2,12)=R;    M(3,3,12)=R;    M(3,4,12)=R;
M(4,1,12)=F;    M(4,2,12)=F;    M(4,3,12)=F;    M(4,4,12)=F;

%Table 13 (bif):
M(1,1,13)=Y;    M(1,2,13)=Y;    M(1,3,13)=F;    M(1,4,13)=F;
M(2,1,13)=LG;   M(2,2,13)=C;    M(2,3,13)=F;    M(2,4,13)=F;
M(3,1,13)=F;    M(3,2,13)=F;    M(3,3,13)=Y;    M(3,4,13)=Y;
M(4,1,13)=F;    M(4,2,13)=F;    M(4,3,13)=F;    M(4,4,13)=F;
