%mIsostericityFilter_Printer.m

if strcmpi(OrganismName{n},'univ')
    %Pick the most populated isoster to be IsosterCompar in case universal numbers are used
    [x,y] = GetabFromUniv(Count(:,:,n,P), M(:,:,round(abs(Table(n)))));
else
    %Assign the IsosterCompar(n,P) to the BP from the source organism from which local numbers are taken (Usually also the crystal structure)
    for x=1:4,if strcmp(Bases(x),PosArray(OrgInd(n),1,n)),break,end,end
    for y=1:4,if strcmp(Bases(y),PosArray(OrgInd(n),2,n)),break,end,end
end

IsosterCompar(n,P) = round(10*M(x,y,round(abs(Table(n)))))/10;%This will set the isostericity value for the BP in the crystal structure (actually, from the organism chosen in mGetPositions, which usually corresponds to the crystal structure)

%%%%%%Next, determine isostericity:
for a=1:4
    for b=1:4
        if Count(a,b,n,P)>0,
            sc = abs(M(a,b,round(abs(Table(n)))) - IsosterCompar(n,P));
            sc = round(10*sc)/10; %to solve the problem of "infinitesimal artificial dicrepancies" with numbers
            if sc == 0,           %Isosteric
                IsostericCount(n,P) = IsostericCount(n,P)+Count(a,b,n,P);
            elseif sc <= 0.2,     %Nearly Isosteric
                NearIsostericCount(n,P) = NearIsostericCount(n,P)+Count(a,b,n,P);
            else
                HeterostericCount(n,P) = HeterostericCount(n,P)+Count(a,b,n,P);      %Note about Heterosteric: Forbidden are also counted here, subtract them later by doing HeterostericCount(n,P)-ForbiddenCount(n,P)
                Isosteric(n,P)=0;
            end
        end
    end
end
Identity{n,P} = '         ';

%%%%%%Next, determine if Forbidden, Gaps, or Allowed:
%%%Forbidden
for a=1:length(BPs)
    for b=1:length(BPs)
        if (M(a,b,round(abs(Table(n))))==0) && (Count(a,b,n,P)>0), %This means not allowed basepair which is populated
            Identity{n,P}='Forbidden';
            ForbiddenCount(n,P)  =   ForbiddenCount(n,P)  +   Count(a,b,n,P);
        end
    end
end

%%%Gaps
for a=1:length(BPs)
    for b=1:length(BPs)
        %if ForbiddenCount(n,P)==0;
            if (M(a,b,round(abs(Table(n))))==13) && (Count(a,b,n,P)>0), %This means gap which is populated
                Identity{n,P}='Gaps     ';
                GapCount(n,P)       =   GapCount(n,P)       +   Count(a,b,n,P);
            end
        %end
    end
end

%%%Allowed
for a=1:length(BPs)
    for b=1:length(BPs)
        %if (ForbiddenCount(n,P)==0) && (GapCount(n,P)==0)
            if (M(a,b,round(abs(Table(n))))~=0) && (M(a,b,round(abs(Table(n))))<13) && (Count(a,b,n,P)>0),
                Identity{n,P}='Allowed  ';
                AllowedCount(n,P)   =   AllowedCount(n,P)   +   Count(a,b,n,P);%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            end
        %end
    end
end

%The following is needed to keep track of what are IsostericANDForbidden, IsostericANDGaps, and IsostericANDAllowed (since any one of them now can be ISOSTERIC)
if strcmp(Identity{n,P},'Forbidden')
    if Isosteric(n,P)==1
        IsostericANDForbidden(n,P)=1;
    else
        IsostericANDForbidden(n,P)=0;
    end
end
if strcmp(Identity{n,P},'Gaps     ')
    if Isosteric(n,P)==1
        IsostericANDGaps(n,P)=1;
    else
        IsostericANDGaps(n,P)=0;
    end
end
if strcmp(Identity{n,P},'Allowed  ')
    if Isosteric(n,P)==1
        IsostericANDAllowed(n,P)=1;
    else
        IsostericANDAllowed(n,P)=0;
    end
end



% % % % % if ForbiddenCount(n,P)>0; %Priority, wins over the rest
% % % % %     fprintf(fidOUTforbidden,'%g\t%g\t%g\t%g\t%s\t%s\t%g\t\t',Univ(InputData(n,1)),Univ(InputData(n,2)),InputData(n,1),InputData(n,2),InputText{n+1,4},DomainNames{P},ForbiddenCount(n,P));%,mIsostericLetter(Isosteric(n,P)));
% % % % %     for a=1:length(BPs)
% % % % %         for b=1:length(BPs)
% % % % %             if (M(a,b,round(abs(Table(n))))==0) && (Count(a,b,n,P)>0),
% % % % %                 for i=1:Count(a,b,n,P),
% % % % %                     fprintf(fidOUTforbidden,'%s\t',SeqName{a,b,n,P,i});
% % % % %                 end
% % % % %             end
% % % % %         end
% % % % %     end
% % % % %     fprintf(fidOUTforbidden,'\n');
% % % % %     Allowed(n,P) = -1; %'Not Allowed';
% % % % %     %end
% % % % % 
% % % % % elseif GapCount(n,P)>0; %Second priority
% % % % %     fprintf(fidOUTgaps,'%g\t%g\t%g\t%g\t%s\t%s\t%g\t\t',Univ(InputData(n,1)),Univ(InputData(n,2)),InputData(n,1),InputData(n,2),InputText{n+1,4},DomainNames{P},GapCount(n,P));%,mIsostericLetter(Isosteric(n,P)));
% % % % %     for a=1:length(BPs)
% % % % %         for b=1:length(BPs)
% % % % %             if (M(a,b,round(abs(Table(n))))==13) && (Count(a,b,n,P)>0), %This means gap which is populated
% % % % %                 for i=1:Count(a,b,n,P),
% % % % %                     fprintf(fidOUTgaps,'%s\t',SeqName{a,b,n,P,i});
% % % % %                 end
% % % % %             end
% % % % %         end
% % % % %     end
% % % % %     fprintf(fidOUTgaps,'\n');
% % % % %     Allowed(n,P) = 0; %'Gaps';
% % % % %     %end
% % % % % 
% % % % % elseif AllowedCount(n,P)>0;
% % % % %     fprintf(fidOUTallowed,'%g\t%g\t%g\t%g\t%s\t%s\t%g\t%s\t\t',Univ(InputData(n,1)),Univ(InputData(n,2)),InputData(n,1),InputData(n,2),InputText{n+1,4},DomainNames{P},AllowedCount(n,P),mIsostericLetter(Isosteric(n,P)));
% % % % %     for a=1:length(BPs)
% % % % %         for b=1:length(BPs)
% % % % %             if (M(a,b,round(abs(Table(n))))~=0) && (M(a,b,round(abs(Table(n))))<13) && (Count(a,b,n,P)>0),
% % % % %                 for i=1:Count(a,b,n,P),
% % % % %                     fprintf(fidOUTallowed,'%s\t',SeqName{a,b,n,P,i});
% % % % %                 end
% % % % %             end
% % % % %         end
% % % % %     end
% % % % %     fprintf(fidOUTallowed,'\n');
% % % % %     Allowed(n,P) = 1; %'Allowed';
% % % % % end


%Next code is for the 10% threashold??
if ForbiddenCount(n,P)> 0.1*(DomainLimits(P+1)-DomainLimits(P)); %Forbidden is priority, wins over the rest
ForbiddenPerc(P)         = ForbiddenPerc(P)       + 1;
    for a=1:length(BPs)
        for b=1:length(BPs)
            if (M(a,b,round(abs(Table(n))))==0) && (Count(a,b,n,P)>0), %This Forbidden which is populated
ForbiddenCountPerc(P)    = ForbiddenCountPerc(P)  + Count(a,b,n,P);
            end
        end
    end
    

elseif GapCount(n,P)> 0.1*(DomainLimits(P+1)-DomainLimits(P)); %Gap is second priority
GapsPerc(P)         = GapsPerc(P)       + 1;
    for a=1:length(BPs)
        for b=1:length(BPs)
            if (M(a,b,round(abs(Table(n))))==13) && (Count(a,b,n,P)>0), %This means gap which is populated
GapsCountPerc(P)    = GapsCountPerc(P)  + Count(a,b,n,P);
            end
        end
    end

else %This should include the ones with less than 10% Forbidden or Gap
AllowedPerc(P)         = AllowedPerc(P)       + 1;
    for a=1:length(BPs)
        for b=1:length(BPs)
            if (M(a,b,round(abs(Table(n))))~=0) && (M(a,b,round(abs(Table(n))))<13) && (Count(a,b,n,P)>0),
AllowedCountPerc(P)    = AllowedCountPerc(P)  + Count(a,b,n,P);
            end
        end
    end
end