function [DomainNames DomainLimits] = mKnownFastaFilenamesChecker(FastaPath,FastaFilename,SeqLen)

KnownFastaFile = strcat(FastaPath,'KnownFastaFilenames.xls');
if exist(KnownFastaFile,'file')
    [InputData, InputText] = xlsread(KnownFastaFile);

    hits=strcmp(InputText(:,1),FastaFilename);
    if sum(hits)==1 %if more or less then there is double matching or
        index=find(hits,1);

        spaces=strfind(InputText{index,2},' ');
        spaces=[0 spaces length(InputText{index,2})+1];
        for i=1:length(spaces)-1
            DomainNames{i} = InputText{index,2}(spaces(i)+1:spaces(i+1)-1);
        end

        DomainLimits = str2num(InputText{index,3});

        %         DomainNames=[];
        %         for i=2:length(InputText(index,:))
        %         DomainNames=[DomainNames InputText(index,i)];
        %         end
        %
        %         DomainLimits = [];
        %         for i=1:length(InputText(index,:))
        %         DomainLimits = [DomainLimits InputData(index,i)];
        %         end

    elseif sum(hits)==0
        fprintf('%s\n','WARNING: FastaFilename was not found in KnownFastaFilenames.xls, assuming one domain');
        DomainNames = {'All'};
        DomainLimits = [0 SeqLen];
    elseif sum(hits)>1
        index=find(hits(1),1);

        spaces=strfind(InputText{index,2},' ');
        spaces=[0 spaces length(InputText{index,2})+1];
        for i=1:length(spaces)-1
            DomainNames{i} = InputText{index,2}(spaces(i)+1:spaces(i+1)-1);
        end

        DomainLimits = str2num(InputText{index,3});

        fprintf('%s\n','WARNING FastaFilename repeat in KnownFastaFilenames.xls, going with the first occurrence');
    end
else
    fprintf('%s\n','WARNING: There was no KnownFastaFilenames.xls on the loaded fasta path, assuming one domain');
    DomainNames = {'All'};
    DomainLimits = [0 SeqLen];
end
