%mMutualCounterBPPrinter_HTML_1table.m     %prints output from mMutualCounterGUI or NoGUI in the form of a matrix

%Use Inc(i,j) to check if this BP needs to be displayed or not
%Count
OutputFileHTML   = strcat(OutputPath,PositionList,'_',FastaFilename,'_COV_',PercentCharacter,'.html');
fidOUTHTML = fopen(OutputFileHTML,'w+');

% fprintf('\n%s%s%s\n','Creating the _COV_',PercentCharacter,'.html output file ...');

fprintf(fidOUTHTML,'%s\n','<html>');
fprintf(fidOUTHTML,'%s\n','<head>');
fprintf(fidOUTHTML,'%s\n','<title>Ribostral Mutual Counter</title>');
fprintf(fidOUTHTML,'%s\n','</head>');
fprintf(fidOUTHTML,'%s\n','<body>');

fprintf(fidOUTHTML,'%s\n','<div align="center">');
fprintf(fidOUTHTML,'%s','<p><font size="5">');
fprintf(fidOUTHTML,'%s %s','Alignment file: ',FastaFilename);
fprintf(fidOUTHTML,'%s\n','</font></p>');
fprintf(fidOUTHTML,'%s','<p><font size="5">');
fprintf(fidOUTHTML,'%s %s','BP list: ',PositionList);
fprintf(fidOUTHTML,'%s\n','</font></p>');

fprintf(fidOUTHTML,'%s','<p><font size="5"><strong>');
fprintf(fidOUTHTML,'%s',ScoreFormula);
fprintf(fidOUTHTML,'%s\n','</font></p></strong>');

fprintf(fidOUTHTML,'%s\n','<font size="5" ><strong>Scores:</font>');
fprintf(fidOUTHTML,'%s\n','<table width="100%" border="2" cellspacing="0" bordercolor="#000000">');
fprintf(fidOUTHTML,'%s\n','  <tr>');
for P=ChosenDomains,
    fprintf(fidOUTHTML,'%s%s%s\n','<td colspan="2" nowrap><div align="center"><strong>',DomainNames{P},'</strong></div></td>');
end
fprintf(fidOUTHTML,'%s\n','  </tr>');
fprintf(fidOUTHTML,'%s\n','  <tr>');
for P=ChosenDomains,
    fprintf(fidOUTHTML,'%s','    <td colspan="2" nowrap><div align="center"><strong><font color="#');
    if TotScore(P)>0,
        fprintf(fidOUTHTML,'%s\n','000000">');
    else fprintf(fidOUTHTML,'%s\n','FF0000">');
    end
    fprintf(fidOUTHTML,'%g%s\n',TotScore(P),'</font></strong></div></td>');
end
fprintf(fidOUTHTML,'%s\n','  </tr>');
fprintf(fidOUTHTML,'%s\n','</table>');

fprintf(fidOUTHTML,'%s','<p><font size="5" color="#FF0000"><strong>');
fprintf(fidOUTHTML,'%s',PercentCharacter);
fprintf(fidOUTHTML,'%s\n','</strong></font></p>');
fprintf(fidOUTHTML,'%s\n','</div>');


% AGc=0;
for n=1:length(InputData(:,1))
    fprintf(fidOUTHTML,'%s','<strong>');
    fprintf(fidOUTHTML,'%s %s','Source of numbers:',OrganismName{n});
    fprintf(fidOUTHTML,'%s\n','</strong><br>');
    
    %First Table:
    if n/100 == fix(n/100),    fprintf('%g\n',n); end
    fprintf(fidOUTHTML,'%s\n','<table width="100%" border="2" cellspacing="0" bordercolor="#000000">');
    fprintf(fidOUTHTML,'%s\n','<tr>');
    
    %Column 1
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s%s\n',DomainNames{P},'<br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
    
    %Column 2
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%g %s%s\n',DomainLimits(P+1)-DomainLimits(P),'seq','<br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
    
    %Column 3
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s','<font color="#');
        fprintf(fidOUTHTML,'%s','FF0000">');
        fprintf(fidOUTHTML,'%g ',ForbiddenCount(n,P));
        fprintf(fidOUTHTML,'%s','F');
        fprintf(fidOUTHTML,'%s\n','</font><br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
    
    %Column 4
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s','<font color="#');
        fprintf(fidOUTHTML,'%s','666666">');
        fprintf(fidOUTHTML,'%g ',GapCount(n,P));
        fprintf(fidOUTHTML,'%s','G');
        fprintf(fidOUTHTML,'%s\n','</font><br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
    
    %Column 5
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s','<font color="#');
        fprintf(fidOUTHTML,'%s','0000FF">');
        fprintf(fidOUTHTML,'%g ',IsostericCount(n,P));
        fprintf(fidOUTHTML,'%s','I');
        fprintf(fidOUTHTML,'%s\n','</font><br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
    
    %Column 6
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s','<font color="#');
        fprintf(fidOUTHTML,'%s','00FFFF">');
        fprintf(fidOUTHTML,'%g ',NearIsostericCount(n,P));
        fprintf(fidOUTHTML,'%s','NI');
        fprintf(fidOUTHTML,'%s\n','</font><br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
    
    %Column 7
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s','<font color="#');
        fprintf(fidOUTHTML,'%s','FF00FF">');
        fprintf(fidOUTHTML,'%g ',HeterostericCount(n,P)-ForbiddenCount(n,P));%This will give Heterosteric Count
        fprintf(fidOUTHTML,'%s','H');
        fprintf(fidOUTHTML,'%s\n','</font><br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
        
    %Column 8
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s','<font color="#');
        if Score(n,P)>0,
            fprintf(fidOUTHTML,'%s\n','000000">');
        else fprintf(fidOUTHTML,'%s\n','FF0000">');
        end
        fprintf(fidOUTHTML,'%s','S=');
        fprintf(fidOUTHTML,'%g ',Score(n,P));
        fprintf(fidOUTHTML,'%s\n','</font><br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');

    %Now let's end First Table
    fprintf(fidOUTHTML,'%s\n%s\n','</tr>','</table>');

    
    %Second Table:
    fprintf(fidOUTHTML,'%s\n','<table width="100%" border="2" cellspacing="0" bordercolor="#000000">');
    fprintf(fidOUTHTML,'%s\n','<tr>');
    fprintf(fidOUTHTML,'%s\n','<td><div align="center"><strong>');
    fprintf(fidOUTHTML,'%g',n);
    fprintf(fidOUTHTML,'%s\n','</strong></div></td>');
    
    fprintf(fidOUTHTML,'%s','<td colspan="');
    fprintf(fidOUTHTML,'%g',length(Bases) + ShowTotals + 1);
    fprintf(fidOUTHTML,'%s\n','"><div align="center">');
    fprintf(fidOUTHTML,'%s','<p><strong>');
    if ~length(regexpi(OrganismName{n},'universal')),   fprintf(fidOUTHTML,'%s',PosArray(OrgInd(n),2,n));  end
    fprintf(fidOUTHTML,'%g',InputData(n,2));
    fprintf(fidOUTHTML,'%s\n','</strong></p></div></td></tr>');
    
    fprintf(fidOUTHTML,'%s\n','<tr>');
    fprintf(fidOUTHTML,'%s','<td width="11%" rowspan="');
    fprintf(fidOUTHTML,'%g',length(Bases) + ShowTotals + 1);
    fprintf(fidOUTHTML,'%s\n','"><p align="center"><strong>');
    if ~length(regexpi(OrganismName{n},'universal')),   fprintf(fidOUTHTML,'%s',PosArray(OrgInd(n),1,n));  end
    fprintf(fidOUTHTML,'%g',InputData(n,1));
    fprintf(fidOUTHTML,'%s\n','</strong></p></td>');
    fprintf(fidOUTHTML,'%s','<td><div align="center"><strong>');
    fprintf(fidOUTHTML,'%s',Interaction{n});
    fprintf(fidOUTHTML,'%s\n','</strong></div></td>');
    for b=1:length(Bases)
        fprintf(fidOUTHTML,'%s%s%s\n','<td width="11%"><div align="center"><strong>',Bases{b},'</strong></div></td>');
    end
    if ShowTotals ==1
        fprintf(fidOUTHTML,'%s%s%s\n','<td width="11%"><div align="center"><strong>','Tot','</strong></div></td>');
    end
    fprintf(fidOUTHTML,'%s\n','</tr>');

        for a=1:length(Bases)
        fprintf(fidOUTHTML,'%s\n','<tr>');
        fprintf(fidOUTHTML,'%s','<td width="11%"><div align="center"><strong>');
        fprintf(fidOUTHTML,'%s',Bases{a});
        fprintf(fidOUTHTML,'%s\n','</strong></div></td>');
        for b=1:length(Bases)
            fprintf(fidOUTHTML,'%s','<td width="11%" bgcolor="#');
            
            [htmlColor guiColor] = mColorByIsostericity(M(a,b,Table(n)));
            fprintf(fidOUTHTML,'%s',htmlColor);

            fprintf(fidOUTHTML,'%s\n','"><div align="center">');
            if (a == X(n,P)) && (b == Y(n,P)) %%%%%%%%%#################?????
%             if strcmp(strcat(Bases(a),Bases(b)),PosArray(OrgInd(n),:,n))==1 %%%%%%%%%#################?????
                fprintf(fidOUTHTML,'%s','<strong><font size="+1">');
            end
            for P=ChosenDomains
                if Percentages == 0
                    fprintf(fidOUTHTML,'%g',Count(a,b,n,P));
                    if ShowExpected ==1,fprintf(fidOUTHTML,'%s%g%s',' (',Expected(a,b,n,P),')');end
                else
                    fprintf(fidOUTHTML,'%g',Percent(a,b,n,P));
                    if ShowExpected ==1,fprintf(fidOUTHTML,'%s%g%s',' (',Expected(a,b,n,P),')');end
                end
                fprintf(fidOUTHTML,'%s\n','<br>');
            end
            if strcmp(strcat(Bases(a),Bases(b)),PosArray(OrgInd(n),:,n))==1
                fprintf(fidOUTHTML,'%s','</font></strong>');
            end
            fprintf(fidOUTHTML,'%s\n','</div></td>');
        end
        if ShowTotals ==1
            fprintf(fidOUTHTML,'%s','<td width="11%"><div align="center">');
            for P=ChosenDomains
                fprintf(fidOUTHTML,'%g%s',SumRows(1,a,n,P),'</br>');
            end
            fprintf(fidOUTHTML,'%s\n','</div></td>');
        end
        fprintf(fidOUTHTML,'%s\n','</tr>');
    end

    if ShowTotals ==1
        fprintf(fidOUTHTML,'%s\n','<tr>');
        fprintf(fidOUTHTML,'%s%s%s','<td width="11%"><div align="center"><strong>','Tot','</strong></div></td>');
        for a=1:length(Bases)
            fprintf(fidOUTHTML,'%s','<td width="11%"><div align="center">');
            for P=ChosenDomains
                fprintf(fidOUTHTML,'%g%s',SumColumns(1,a,n,P),'<br>');
            end
            fprintf(fidOUTHTML,'%s\n','</div></td>');
        end
        fprintf(fidOUTHTML,'%s','<td width="11%"><div align="center">');
        for P=ChosenDomains
            fprintf(fidOUTHTML,'%g%s',SumTotal(n,P),'<br>');
        end
        fprintf(fidOUTHTML,'%s\n','</div></td>');
        fprintf(fidOUTHTML,'%s\n','</tr>');
    end

    fprintf(fidOUTHTML,'%s\n','</table>');


    fprintf(fidOUTHTML,'<p></p>');
end
    
fprintf(fidOUTHTML,'%s\n','<title>Ribostral Mutual Counter<body>');
fprintf(fidOUTHTML,'%s\n','<title>Ribostral Mutual Counter</html>');
fclose(fidOUTHTML);



