%mMutualCounterBPPrinter_HTML_1table_Sequences.m     %prints names of sequences that go with the 1table.html output

%Use Inc(i,j) to check if this BP needs to be displayed or not
%Count
OutputFileHTMLseq   = strcat(OutputPath,PositionList,'_',FastaFilename,'_SEQ.html');
fidOUTHTMLseq = fopen(OutputFileHTMLseq,'w+');

% fprintf('\n%s\n','Creating the _SEQ.html output file ...');

fprintf(fidOUTHTMLseq,'%s\n','<html>');
fprintf(fidOUTHTMLseq,'%s\n','<head>');
fprintf(fidOUTHTMLseq,'%s\n','<title>Ribostral Mutual Counter</title>');
fprintf(fidOUTHTMLseq,'%s\n','</head>');
fprintf(fidOUTHTMLseq,'%s\n','<body>');

fprintf(fidOUTHTMLseq,'%s\n','<div align="center">');
fprintf(fidOUTHTMLseq,'%s','<p><font size="5">');
fprintf(fidOUTHTMLseq,'%s %s','Fasta Alignment File:',FastaFilename);
fprintf(fidOUTHTMLseq,'%s\n','</font></p>');
fprintf(fidOUTHTMLseq,'%s','<p><font size="5">');
fprintf(fidOUTHTMLseq,'%s %s','Positions Excel File:',PositionList);
fprintf(fidOUTHTMLseq,'%s\n','</font></p>');

fprintf(fidOUTHTML,'%s\n','<font size="5" ><strong>Scores (+100 is perfect):</font>');
fprintf(fidOUTHTML,'%s\n','<table width="100%" border="2" cellspacing="0" bordercolor="#000000">');
fprintf(fidOUTHTML,'%s\n','  <tr>');
for P=ChosenDomains,
    fprintf(fidOUTHTML,'%s%s%s\n','<td colspan="2" nowrap><div align="center"><strong>',DomainNames{P},'</strong></div></td>');
end
fprintf(fidOUTHTML,'%s\n','  </tr>');
fprintf(fidOUTHTML,'%s\n','  <tr>');
for P=ChosenDomains,
    fprintf(fidOUTHTML,'%s%g%s\n','    <td colspan="2" nowrap><div align="center"><strong>',Score(P),'</strong></div></td>');
end
fprintf(fidOUTHTML,'%s\n','  </tr>');
fprintf(fidOUTHTML,'%s\n','</table>');

fprintf(fidOUTHTMLseq,'%s','<p><font size="5" color="#FF0000"><strong>');
fprintf(fidOUTHTMLseq,'%s','SEQUENCE NAMES');
fprintf(fidOUTHTMLseq,'%s\n','</strong></font></p>');
fprintf(fidOUTHTMLseq,'%s\n','</div>');


% AGc=0;
for n=1:length(InputData(:,1))
    fprintf(fidOUTHTMLseq,'%s','<strong>');
    fprintf(fidOUTHTMLseq,'%s %s','Source of numbers:',OrganismName{n});
    fprintf(fidOUTHTMLseq,'%s\n','</strong><br>');

    %First Table:
    if n/100 == fix(n/100),    fprintf('%g\n',n); end
    fprintf(fidOUTHTML,'%s\n','<table width="100%" border="2" cellspacing="0" bordercolor="#000000">');
    fprintf(fidOUTHTML,'%s\n','<tr>');
    
    %Column 1
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s%s\n',DomainNames{P},'<br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
    
    %Column 2
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%g %s%s\n',DomainLimits(P+1)-DomainLimits(P),'seq','<br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
    
    %Column 3
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s','<font color="#');
        fprintf(fidOUTHTML,'%s','FF0000">');
        fprintf(fidOUTHTML,'%g ',ForbiddenCount(n,P));
        fprintf(fidOUTHTML,'%s','F');
        fprintf(fidOUTHTML,'%s\n','</font><br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
    
    %Column 4
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s','<font color="#');
        fprintf(fidOUTHTML,'%s','666666">');
        fprintf(fidOUTHTML,'%g ',GapCount(n,P));
        fprintf(fidOUTHTML,'%s','G');
        fprintf(fidOUTHTML,'%s\n','</font><br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
    
    %Column 5
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s','<font color="#');
        fprintf(fidOUTHTML,'%s','0000FF">');
        fprintf(fidOUTHTML,'%g ',IsostericCount(n,P));
        fprintf(fidOUTHTML,'%s','I');
        fprintf(fidOUTHTML,'%s\n','</font><br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
    
    %Column 6
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s','<font color="#');
        fprintf(fidOUTHTML,'%s','00FFFF">');
        fprintf(fidOUTHTML,'%g ',NearIsostericCount(n,P));
        fprintf(fidOUTHTML,'%s','NI');
        fprintf(fidOUTHTML,'%s\n','</font><br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
    
    %Column 7
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');    
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s','<font color="#');
        fprintf(fidOUTHTML,'%s','FF00FF">');
        fprintf(fidOUTHTML,'%g ',HeterostericCount(n,P)-ForbiddenCount(n,P));%This will give Heterosteric Count
        fprintf(fidOUTHTML,'%s','H');
        fprintf(fidOUTHTML,'%s\n','</font><br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');
        
    %Column 8
    fprintf(fidOUTHTML,'%s\n','<td width="12.5%" nowrap><div align="center">');
    for P=ChosenDomains,
        fprintf(fidOUTHTML,'%s','<font color="#');
        if Score(n,P)>0,
            fprintf(fidOUTHTML,'%s\n','000000">');
        else fprintf(fidOUTHTML,'%s\n','FF0000">');
        end
        fprintf(fidOUTHTML,'%s','S=');
        fprintf(fidOUTHTML,'%g ',Score(n,P));
        fprintf(fidOUTHTML,'%s\n','</font><br>');
    end
    fprintf(fidOUTHTML,'%s\n%s\n','</div>','</td>');

    %Now let's end First Table
    fprintf(fidOUTHTML,'%s\n%s\n','</tr>','</table>');

    
    %Second Table:
    fprintf(fidOUTHTMLseq,'%s\n','<table width="100%" border="2" cellspacing="0" bordercolor="#000000">');
    fprintf(fidOUTHTMLseq,'%s\n','<tr>');
    fprintf(fidOUTHTMLseq,'%s\n','<td><div align="center"><strong>');
    fprintf(fidOUTHTMLseq,'%g',n);
    fprintf(fidOUTHTMLseq,'%s\n','</strong></div></td>');
    
    fprintf(fidOUTHTMLseq,'%s','<td colspan="');
    fprintf(fidOUTHTMLseq,'%g',length(Bases) + ShowTotals + 1);
    fprintf(fidOUTHTMLseq,'%s\n','"><div align="center">');
    fprintf(fidOUTHTMLseq,'%s','<p><strong>');
    if ~length(regexpi(OrganismName{n},'universal')),   fprintf(fidOUTHTMLseq,'%s',PosArray(OrgInd(n),2,n));  end
    fprintf(fidOUTHTMLseq,'%g',InputData(n,2));
    fprintf(fidOUTHTMLseq,'%s\n','</strong></p></div></td></tr>');
    
    fprintf(fidOUTHTMLseq,'%s\n','<tr>');
    fprintf(fidOUTHTMLseq,'%s','<td width="11%" rowspan="');
    fprintf(fidOUTHTMLseq,'%g',length(Bases) + ShowTotals + 1);
    fprintf(fidOUTHTMLseq,'%s\n','"><p align="center"><strong>');
    if ~length(regexpi(OrganismName{n},'universal')),   fprintf(fidOUTHTMLseq,'%s',PosArray(OrgInd(n),1,n));  end
    fprintf(fidOUTHTMLseq,'%g',InputData(n,1));
    fprintf(fidOUTHTMLseq,'%s\n','</strong></p></td>');
    fprintf(fidOUTHTMLseq,'%s','<td><div align="center"><strong>');
    fprintf(fidOUTHTMLseq,'%s',Interaction{n});
    fprintf(fidOUTHTMLseq,'%s\n','</strong></div></td>');
    for b=1:length(Bases)
        fprintf(fidOUTHTMLseq,'%s%s%s\n','<td width="11%"><div align="center"><strong>',Bases{b},'</strong></div></td>');
    end
    if ShowTotals ==1
        fprintf(fidOUTHTMLseq,'%s%s%s\n','<td width="11%"><div align="center"><strong>','Tot','</strong></div></td>');
    end
    fprintf(fidOUTHTMLseq,'%s\n','</tr>');

    for a=1:length(Bases)
        fprintf(fidOUTHTMLseq,'%s\n','<tr>');
        fprintf(fidOUTHTMLseq,'%s','<td width="11%"><div align="center"><strong>');
        fprintf(fidOUTHTMLseq,'%s',Bases{a});
        fprintf(fidOUTHTMLseq,'%s\n','</strong></div></td>');
        for b=1:length(Bases)
            fprintf(fidOUTHTMLseq,'%s','<td width="11%" bgcolor="#');

            [htmlColor guiColor] = mColorByIsostericity(M(a,b,Table(n)));
            fprintf(fidOUTHTML,'%s',htmlColor);

            fprintf(fidOUTHTMLseq,'%s\n','"nowrap><div align="left">');
            if (a == X(n,P)) && (b == Y(n,P)) %%%%%%%%%#################?????
%             if strcmp(strcat(Bases(a),Bases(b)),PosArray(OrgInd(n),:,n))==1 %%%%%%%%%#################?????
                fprintf(fidOUTHTMLseq,'%s','<strong><font size="+1">');
            end
            for P=ChosenDomains
                %if Count(a,b,n,P)>0
                for i=1:Count(a,b,n,P),
                    fprintf(fidOUTHTMLseq,'%s\t',SeqName{a,b,n,P,i});%%%%%%%%%%%%%%%%THIS IS THE CORE%%%%%%%%%
                end
                %else
                %    fprintf(fidOUTHTMLseq,'%s\t','-');
                %end
                fprintf(fidOUTHTMLseq,'%s\n','<br>');
            end
            if strcmp(strcat(Bases(a),Bases(b)),PosArray(OrgInd(n),:,n))==1
                fprintf(fidOUTHTMLseq,'%s','</font></strong>');
            end
            fprintf(fidOUTHTMLseq,'%s\n','</div></td>');
        end
        if ShowTotals ==1
            fprintf(fidOUTHTMLseq,'%s','<td width="11%"><div align="center">');
            for P=ChosenDomains
                fprintf(fidOUTHTMLseq,'%g%s',SumRows(1,a,n,P),'</br>');
            end
            fprintf(fidOUTHTMLseq,'%s\n','</div></td>');
        end
        fprintf(fidOUTHTMLseq,'%s\n','</tr>');
    end

    if ShowTotals ==1
        fprintf(fidOUTHTMLseq,'%s\n','<tr>');
        fprintf(fidOUTHTMLseq,'%s%s%s','<td width="11%"><div align="center"><strong>','Tot','</strong></div></td>');
        for a=1:length(Bases)
            fprintf(fidOUTHTMLseq,'%s','<td width="11%"><div align="center">');
            for P=ChosenDomains
                fprintf(fidOUTHTMLseq,'%g%s',SumColumns(1,a,n,P),'<br>');
            end
            fprintf(fidOUTHTMLseq,'%s\n','</div></td>');
        end
        fprintf(fidOUTHTMLseq,'%s','<td width="11%"><div align="center">');
        for P=ChosenDomains
            fprintf(fidOUTHTMLseq,'%g%s',SumTotal(n,P),'<br>');
        end
        fprintf(fidOUTHTMLseq,'%s\n','</div></td>');
        fprintf(fidOUTHTMLseq,'%s\n','</tr>');
    end

    fprintf(fidOUTHTMLseq,'%s\n','</table>');


    fprintf(fidOUTHTMLseq,'<p></p>');
end
    
fprintf(fidOUTHTMLseq,'%s\n','<title>Ribostral Mutual Counter<body>');
fprintf(fidOUTHTMLseq,'%s\n','<title>Ribostral Mutual Counter</html>');
fclose(fidOUTHTMLseq);



