%mMutualCounterBPPrinter_Special2GU.m  %User defined output format

OutputFileS     = strcat(OutputPath,PositionList,'_',FastaFilename,'_COV_SpecialGU_',PercentCharacter,'.out');
fidOUTS = fopen(OutputFileS,'w+');
if fidOUTS == -1      %Error check loop
    ErrorOUTS = ['The file: ',OutputFileS,' could not be written to. It may be open. Please close it and try again'];
end


fprintf(fidOUTS,'\n%s\t\t%s\n','Fasta Alignment File',FastaFilename);
fprintf(fidOUTS,'%s\t\t%s\n','Positions Excel File',PositionList);

fprintf(fidOUTS,'\t\t\t\t');
for P=ChosenDomains
    fprintf(fidOUTS,'%s',DomainNames{P});
    fprintf(fidOUTS,' %s%g %s','(',DomainLimits(P+1)-DomainLimits(P),'sequences)');
    if ShowTotals ==1
        fprintf(fidOUTS,'\t\t\t\t\t\t\t');
    else fprintf(fidOUTS,'\t\t\t\t\t\t');
    end
end
fprintf(fidOUTS,'\n');

    fprintf(fidOUTS,'%s\t%s\t%s\t%s','#','Organism','NT1','NT2');

    SpecialGUBP={'GU','AC','WC','UG','CA','NT'};
    for P=ChosenDomains
        for a = 1:length(SpecialGUBP)
            fprintf(fidOUTS,'\t%s',SpecialGUBP{a});
        end
        if ShowTotals ==1
            fprintf(fidOUTS,'\t%s','Tot');
        end
    end

    fprintf(fidOUTS,'\n');
    for n=1:length(InputData(:,1))


        fprintf(fidOUTS,'%g',n);
        fprintf(fidOUTS,'\t');
        fprintf(fidOUTS,'%s',OrganismName{n});
        fprintf(fidOUTS,'\t');
        fprintf(fidOUTS,'%g\t%g',InputData(n,1),InputData(n,2));

        for P=ChosenDomains

            %SpecialGUBP={'GU','AC','WC','UG','CA','NTs'};
            SpecialGUCount(1) =   Count(3,4,n,P);     %GU
            SpecialGUCount(2) =   Count(1,2,n,P);     %AC
            SpecialGUCount(3) =   Count(1,4,n,P) + Count(2,3,n,P) + Count(3,2,n,P) + Count(4,1,n,P);  %WC
            SpecialGUCount(4) =   Count(4,3,n,P);     %UG
            SpecialGUCount(5) =   Count(2,1,n,P);     %CA
            SpecialGUCount(6) =   sum(sum(Count(1:4,1:4,n,P))) - sum(SpecialGUCount(1:5));%All the rest of REAL BP's (not gaps, not o's)

            SpecialGUPercent(1) =   Percent(3,4,n,P);     %GU
            SpecialGUPercent(2) =   Percent(1,2,n,P);     %AC
            SpecialGUPercent(3) =   Percent(1,4,n,P) + Percent(2,3,n,P) + Percent(3,2,n,P) + Percent(4,1,n,P);  %WC
            SpecialGUPercent(4) =   Percent(4,3,n,P);     %UG
            SpecialGUPercent(5) =   Percent(2,1,n,P);     %CA
            SpecialGUPercent(6) =   sum(sum(Percent(1:4,1:4,n,P))) - sum(SpecialGUPercent(1:5));%All the rest of REAL BP's (not gaps, not o's)

            SpecialGUExpected(1) =   Expected(3,4,n,P);     %GU
            SpecialGUExpected(2) =   Expected(1,2,n,P);     %AC
            SpecialGUExpected(3) =   Expected(1,4,n,P) + Expected(2,3,n,P) + Expected(3,2,n,P) + Expected(4,1,n,P);  %WC
            SpecialGUExpected(4) =   Expected(4,3,n,P);     %UG
            SpecialGUExpected(5) =   Expected(2,1,n,P);     %CA
            SpecialGUExpected(6) =   sum(sum(Expected(1:4,1:4,n,P))) - sum(SpecialGUExpected(1:5));%All the rest of REAL BP's (not gaps, not o's)

            for a=1:length(SpecialGUCount)
                if Percentages == 0
                    fprintf(fidOUTS,'\t%g',SpecialGUCount(a));
                    if ShowExpected ==1,fprintf(fidOUTS,'%s%g%s',' (',SpecialGUExpected(a),')');end
                else
                    fprintf(fidOUTS,'\t%g',SpecialGUPercent(a));
                    if ShowExpected ==1,fprintf(fidOUTS,'%s%g%s',' (',SpecialGUExpected(a),')');end
                end
            end
            if ShowTotals ==1
                fprintf(fidOUTS,'\t%g',SumTotal(n,P));
            end
        end
        fprintf(fidOUTS,'\n');
    end

%clc;
if fidOUTS ~= -1
    status = fclose(fidOUTS); %Closing the .out file
    fprintf('\n%s\n%s\n','The SpecialGU output data was saved as:',OutputFileS);
else%%%%%%%%%Reporting errors at the end
    ErrorOUTS
    if Audio == 1
        try
        [Ys,Fs] = wavread(['..',filesep,'Audio',filesep,'ohno']);
        sound(Ys,Fs); %wavplay(Ys,Fs,'async')
        end
    end
end
