%mPlotBPScores.m  %Ali Mokdad, March 12, 2006. Hint: make wi=1 and rest of
%weights=0 (in SCORES.txt) to get a plot of isosteric substitutions for each BP
function ColCount = mPlotBPScores(handles,ChosenDomains,ColCount)
ScoreFormula    = handles.Plot.ScoreFormula;
corc            = handles.Plot.corc;
wmax            = handles.Plot.wmax;
wmin            = handles.Plot.wmin;
TotScore        = handles.Plot.TotScore;
Score           = handles.Plot.Score;
% DomainLimits    = handles.DomainLimits;
DomainNames     = handles.DomainNames;
% Table           = handles.Table;
InputData       = handles.InputData;
FastaFilename   = handles.FastaFilename;
PositionList    = handles.PositionList;

yMax=corc*wmax;              %%%this is often + 100 (depending on "corc" defined in mReadSCOREweights.m)
yMin=(corc*wmin);            %%%this is often about -100 (depending on the formula for SCORE)
if yMin==yMax, yMin = 0, end %in case only one weight is non-zero!

if ishandle(123) %123 is  always the handle of the Scores Figure, if present more curves will be appended to it, if absent a new such plot will be started (if you use gcf it will always point to the GUI)
    OldPos = get(123,'Position');
else OldPos = [(.27) (0.27) .70 .65];
    ColCount=0;
end

FigName='Alignment Isostericity Scores';%[DomainNames{P},' scores'];
% AxesTitle={['Alignment file: ',FastaFilename] ; ['BP list: ',PositionList] ; ScoreFormula};
AxesTitle = ScoreFormula;

ScoresFig = figure(123); %The handle 123 is reserved in ribostral for of this Scores figure
set(ScoresFig,'NumberTitle','off','name',FigName,'Units','normalized','Position',OldPos);
title(AxesTitle,'Interpreter', 'none');
set(gca,'XLim',[1 length(InputData(:,1))],'YLim',[1.1*yMin 1.1*yMax],'Xgrid','on');
xlabel('Basepair (in order of BP list)');
ylabel('Score');
hold on

col='rgbmcyk';

for P=ChosenDomains
    if P>length(TotScore) || sum(Score(:,P))==0 %(can not reverse these 2 conditions)
        Message=[DomainNames{P},' is not plotted because it was not analyzed'];
        fprintf('%s\n',Message);
        text(1.3,1.1*yMin + 10*P,Message,'BackgroundColor',[.5 .5 .5])
    else
        ColCount=ColCount+1;
        if ColCount>length(col),ColCount=1;end     %recycle through the colors
        line([1,length(InputData(:,1))],[TotScore(P),TotScore(P)],'Color',col(ColCount),'LineStyle',':')
        Message=[DomainNames{P},' (av: ',num2str(TotScore(P)),')'];
        text(-6,TotScore(P),Message,'Color',col(ColCount),'BackgroundColor',[.5 .5 .5])
%         mLabelTick('Y',TotScore(P),Message)

        line(1:length(InputData(:,1)),Score(:,P),'Color',col(ColCount))
    end
end

