%mReadSCOREweights.m  
%Reads text file containing the isosteric subfamily weights to be used with scores

%wi=3; wni=2; wh=-1; wf=-2; wg1=-2; wg2=-3;
wn={'wi','wni','wh','wf','wg1','wg2'};%,'corc','wmax','wmin'};
wi=0; wni=0; wh=0; wf=0; wg1=0; wg2=0;

w = textread('SCORES.txt','%s','commentstyle','matlab','whitespace', '','delimiter',';');
%[wi,wni,wh,wf,wg1,wg2]

%fprintf('%s\n','Weights used for scoring isosteric subfamilies:'); %Now this is done better by the colde below

for i=1:length(wn)
    sf=strfind(lower(w),wn{i});
    for j=1:length(sf)
        if ~isempty(sf{j})
            ind=findstr('=',w{j});
            value=(w{j}(ind+1:end));
            text=lower(w{j}(1:ind-1));
            eval([text '=' value ';']);
            %fprintf('%s = %s; ',text,value);                       %Now this is done better by the colde below
        end
    end
end

% fprintf('\n     ');

wmax=max([wi,wni,wh,wf,wg1,wg2]);
wmin=min([wi,wni,wh,wf,wg1,wg2]);
corc=100/wmax;  %I like this, this makes maximum score always +100
% corc=100;       %Leontis likes this, it reflects the weights seen here better without deviding by the highest weight


%%%%%%Next is just to create a text that can be printed everywhere to tell
%%%%%%the user what formula was used
ScoreFormula = ['Score Formula = ',num2str(corc),'*('];
for i=1:length(wn)
    if eval(wn{i})~=0
        if i==1
            if eval(wn{i})==1
                ScoreFormula=[ScoreFormula upper(wn{i}(2:end))];
            else
                ScoreFormula=[ScoreFormula num2str(eval(wn{i})) upper(wn{i}(2:end))];
            end
        else
            if eval(wn{i})>0
                if eval(wn{i})==1
                    ScoreFormula=[ScoreFormula '+' upper(wn{i}(2:end))];
                else
                    ScoreFormula=[ScoreFormula '+' num2str(eval(wn{i})) upper(wn{i}(2:end))];
                end
            else
                if eval(wn{i})==1
                    ScoreFormula=[ScoreFormula upper(wn{i}(2:end))];
                else
                    ScoreFormula=[ScoreFormula num2str(eval(wn{i})) upper(wn{i}(2:end))];
                end
            end
        end
    end
end
ScoreFormula = [ScoreFormula,')/num of seqs'];

fprintf('%s\n',ScoreFormula);

fprintf('     ');
