function setBackgroundColor(hPb,color)
% SETBACKGROUNDCOLOR Set the background color of a Pushbutton using CData workaround 
%     setBackgroundColor(hPb,color) sets the Background Color of a
%     PushButton with handle "hPb" to the color given in Truecolor
%     space "color". This function uses the CData property of the
%     Pushbutton to workaround the BackgroundColor bug on the Mac OS 10.3.
%

oldPbUnits = get(hPb,'Units');
set(hPb,'Units','pixels');
posPb = get(hPb,'Position');
backImSiz = round(posPb([4 3]));

cdat = shiftdim(repmat(color,[backImSiz(2) 1 backImSiz(1)]),2);
set(hPb,'CData',cdat);

set(hPb,'Units',oldPbUnits);